/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.LinearScaler;
import cytoscape.util.RankScaler;
import cytoscape.util.Scaler;
import java.util.Map;
import java.util.TreeMap;

public class ScalerFactory {
    private static Map<String, Scaler> typeToScalerMap = null;

    public static synchronized Scaler getScaler(String type) throws IllegalArgumentException {
        Scaler scaler;
        if (typeToScalerMap == null) {
            ScalerFactory.init();
        }
        if ((scaler = typeToScalerMap.get(type)) == null) {
            throw new IllegalArgumentException("unknown type \"" + type + "\"!");
        }
        return scaler;
    }

    public static synchronized void registerScaler(String type, Scaler newScaler) {
        if (typeToScalerMap == null) {
            ScalerFactory.init();
        }
        if (typeToScalerMap.containsKey(type)) {
            throw new IllegalArgumentException("trying to register a duplicate type \"" + type + "\"!");
        }
        typeToScalerMap.put(type, newScaler);
    }

    private static void init() {
        if (typeToScalerMap != null) {
            throw new IllegalStateException("already initialised!");
        }
        typeToScalerMap = new TreeMap<String, Scaler>();
        typeToScalerMap.put("linear", new LinearScaler());
        typeToScalerMap.put("rank", new RankScaler());
    }
}

