/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.Node;
import cytoscape.util.TopoGraphNode;
import cytoscape.util.TopologicalSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalSortTest
extends TestCase {
    public void testWikipediaExample() {
        Node node7 = new Node("7");
        Node node5 = new Node("5");
        Node node3 = new Node("3");
        Node node11 = new Node("11");
        Node node8 = new Node("8");
        Node node2 = new Node("2");
        Node node9 = new Node("9");
        Node node10 = new Node("10");
        node7.addDependent(node11);
        node7.addDependent(node8);
        node5.addDependent(node11);
        node3.addDependent(node8);
        node3.addDependent(node10);
        node11.addDependent(node2);
        node11.addDependent(node9);
        node11.addDependent(node10);
        node8.addDependent(node9);
        ArrayList<TopoGraphNode> nodes = new ArrayList<TopoGraphNode>();
        nodes.add(node7);
        nodes.add(node5);
        nodes.add(node3);
        nodes.add(node11);
        nodes.add(node8);
        nodes.add(node2);
        nodes.add(node9);
        nodes.add(node10);
        List<TopoGraphNode> order = TopologicalSort.sort(nodes);
        TopologicalSortTest.assertTrue(this.isTopologicalOrder(order));
    }

    public void testGraphWithSomeUnconnectedNodes() {
        Node node7 = new Node("7");
        Node node5 = new Node("5");
        Node node3 = new Node("3");
        Node node11 = new Node("11");
        Node node8 = new Node("8");
        Node node2 = new Node("2");
        Node node9 = new Node("9");
        Node node10 = new Node("10");
        Node nodeU1 = new Node("U3");
        Node nodeU2 = new Node("U2");
        Node nodeU3 = new Node("U1");
        node7.addDependent(node11);
        node7.addDependent(node8);
        node5.addDependent(node11);
        node3.addDependent(node8);
        node3.addDependent(node10);
        node11.addDependent(node2);
        node11.addDependent(node9);
        node11.addDependent(node10);
        node8.addDependent(node9);
        ArrayList<TopoGraphNode> nodes = new ArrayList<TopoGraphNode>();
        nodes.add(node7);
        nodes.add(node5);
        nodes.add(node3);
        nodes.add(node11);
        nodes.add(node8);
        nodes.add(node2);
        nodes.add(node9);
        nodes.add(node10);
        List<TopoGraphNode> order = TopologicalSort.sort(nodes);
        TopologicalSortTest.assertTrue(this.isTopologicalOrder(order));
    }

    public void testIndirectCycle() {
        boolean failed;
        Node nodeA = new Node("A");
        Node nodeB = new Node("B");
        Node nodeC = new Node("C");
        nodeA.addDependent(nodeB);
        nodeB.addDependent(nodeC);
        nodeC.addDependent(nodeA);
        ArrayList<TopoGraphNode> nodes = new ArrayList<TopoGraphNode>();
        nodes.add(nodeA);
        nodes.add(nodeB);
        nodes.add(nodeC);
        try {
            TopologicalSort.sort(nodes);
            failed = false;
        }
        catch (IllegalStateException e) {
            failed = true;
        }
        TopologicalSortTest.assertTrue(failed);
    }

    public void testSelfLoopCycle() {
        boolean failed;
        Node nodeA = new Node("A");
        Node nodeB = new Node("B");
        Node nodeC = new Node("C");
        nodeB.addDependent(nodeB);
        ArrayList<TopoGraphNode> nodes = new ArrayList<TopoGraphNode>();
        nodes.add(nodeA);
        nodes.add(nodeB);
        nodes.add(nodeC);
        try {
            TopologicalSort.sort(nodes);
            failed = false;
        }
        catch (IllegalStateException e) {
            failed = true;
        }
        TopologicalSortTest.assertTrue(failed);
    }

    private boolean isTopologicalOrder(Collection<TopoGraphNode> topoOrderCandidate) {
        TopoGraphNode[] orderAsArray = topoOrderCandidate.toArray(new TopoGraphNode[topoOrderCandidate.size()]);
        for (int i = 0; i < orderAsArray.length; ++i) {
            Collection<TopoGraphNode> dependents = orderAsArray[i].getDependents();
            for (int k = i + 1; k < orderAsArray.length; ++k) {
                if (!dependents.contains(orderAsArray[k])) continue;
                return false;
            }
        }
        return true;
    }
}

