/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.logger.CyLogger;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class LabelPosition {
    public static final String northWestName = "Northwest";
    public static final String northName = "North";
    public static final String northEastName = "Northeast";
    public static final String westName = "West";
    public static final String centerName = "Center";
    public static final String eastName = "East";
    public static final String southWestName = "Southwest";
    public static final String southName = "South";
    public static final String southEastName = "Southeast";
    protected static final String nwName = "NW";
    protected static final String nName = "N";
    protected static final String neName = "NE";
    protected static final String wName = "W";
    protected static final String cName = "C";
    protected static final String eName = "E";
    protected static final String swName = "SW";
    protected static final String sName = "S";
    protected static final String seName = "SE";
    public static final String noName = "none";
    public static final String justifyCenterName = "Center Justified";
    public static final String justifyLeftName = "Left Justified";
    public static final String justifyRightName = "Right Justified";
    protected static final String justifyCName = "c";
    protected static final String justifyLName = "l";
    protected static final String justifyRName = "r";
    protected int labelAnchor;
    protected int targetAnchor;
    protected int justify;
    protected double xOffset;
    protected double yOffset;
    public static final LabelPosition DEFAULT = new LabelPosition();

    public LabelPosition() {
        this(4, 4, 64, 0.0, 0.0);
    }

    public LabelPosition(LabelPosition lp) {
        this.targetAnchor = lp.getTargetAnchor();
        this.labelAnchor = lp.getLabelAnchor();
        this.xOffset = lp.getOffsetX();
        this.yOffset = lp.getOffsetY();
        this.justify = lp.getJustify();
    }

    public LabelPosition(int targ, int lab, int just, double x, double y) {
        this.targetAnchor = targ;
        this.labelAnchor = lab;
        this.justify = just;
        this.xOffset = x;
        this.yOffset = y;
    }

    public int getLabelAnchor() {
        return this.labelAnchor;
    }

    public int getTargetAnchor() {
        return this.targetAnchor;
    }

    public int getJustify() {
        return this.justify;
    }

    public double getOffsetX() {
        return this.xOffset;
    }

    public double getOffsetY() {
        return this.yOffset;
    }

    public void setLabelAnchor(int b) {
        this.labelAnchor = b;
    }

    public void setTargetAnchor(int b) {
        this.targetAnchor = b;
    }

    public void setJustify(int b) {
        this.justify = b;
    }

    public void setOffsetX(double d) {
        this.xOffset = d;
    }

    public void setOffsetY(double d) {
        this.yOffset = d;
    }

    public boolean equals(Object lp) {
        if (lp == null) {
            return false;
        }
        if (lp instanceof LabelPosition) {
            LabelPosition LP = (LabelPosition)lp;
            if (Math.abs(LP.getOffsetX() - this.xOffset) > 1.0E-7) {
                CyLogger.getLogger().info("xoff");
                return false;
            }
            if (Math.abs(LP.getOffsetY() - this.yOffset) > 1.0E-7) {
                CyLogger.getLogger().info("yoff");
                return false;
            }
            if (LP.getLabelAnchor() != this.labelAnchor) {
                CyLogger.getLogger().info("label");
                return false;
            }
            if (LP.getTargetAnchor() != this.targetAnchor) {
                CyLogger.getLogger().info("taret");
                return false;
            }
            if (LP.getJustify() != this.justify) {
                CyLogger.getLogger().info("justify");
                return false;
            }
            return true;
        }
        return false;
    }

    public static String convert(int b) {
        switch (b) {
            case 1: {
                return northName;
            }
            case 7: {
                return southName;
            }
            case 5: {
                return eastName;
            }
            case 3: {
                return westName;
            }
            case 0: {
                return northWestName;
            }
            case 2: {
                return northEastName;
            }
            case 6: {
                return southWestName;
            }
            case 8: {
                return southEastName;
            }
            case 4: {
                return centerName;
            }
            case 127: {
                return noName;
            }
            case 64: {
                return justifyCenterName;
            }
            case 65: {
                return justifyLeftName;
            }
            case 66: {
                return justifyRightName;
            }
        }
        return null;
    }

    public static int convert(String s) {
        if (northName.equals(s) || nName.equals(s)) {
            return 1;
        }
        if (southName.equals(s) || sName.equals(s)) {
            return 7;
        }
        if (eastName.equals(s) || eName.equals(s)) {
            return 5;
        }
        if (westName.equals(s) || wName.equals(s)) {
            return 3;
        }
        if (northWestName.equals(s) || nwName.equals(s)) {
            return 0;
        }
        if (northEastName.equals(s) || neName.equals(s)) {
            return 2;
        }
        if (southWestName.equals(s) || swName.equals(s)) {
            return 6;
        }
        if (southEastName.equals(s) || seName.equals(s)) {
            return 8;
        }
        if (centerName.equals(s) || cName.equals(s)) {
            return 4;
        }
        if (justifyCenterName.equals(s) || justifyCName.equals(s)) {
            return 64;
        }
        if (justifyLeftName.equals(s) || justifyLName.equals(s)) {
            return 65;
        }
        if (justifyRightName.equals(s) || justifyRName.equals(s)) {
            return 66;
        }
        return -1;
    }

    public static String[] getJustifyNames() {
        String[] s = new String[]{justifyLeftName, justifyCenterName, justifyRightName};
        return s;
    }

    public static String[] getAnchorNames() {
        String[] s = new String[]{northWestName, northName, northEastName, westName, centerName, eastName, southWestName, southName, southEastName};
        return s;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("target: ").append(LabelPosition.convert(this.targetAnchor));
        sb.append("  label: ").append(LabelPosition.convert(this.labelAnchor));
        sb.append("  justify: ").append(LabelPosition.convert(this.justify));
        sb.append("  X offset: ").append(Double.toString(this.xOffset));
        sb.append("  Y offset: ").append(Double.toString(this.yOffset));
        return sb.toString();
    }

    public String shortString() {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        StringBuffer sb = new StringBuffer();
        sb.append(LabelPosition.getShortName(this.targetAnchor));
        sb.append(",");
        sb.append(LabelPosition.getShortName(this.labelAnchor));
        sb.append(",");
        sb.append(LabelPosition.getShortName(this.justify));
        sb.append(",");
        sb.append(df.format(this.xOffset));
        sb.append(",");
        sb.append(df.format(this.yOffset));
        return sb.toString();
    }

    public static LabelPosition parse(String value) {
        Pattern p = Pattern.compile("^([NSEWC]{1,2}+),([NSEWC]{1,2}+),([clr]{1}+),(-?\\d+(.\\d+)?),(-?\\d+(.\\d+)?)$");
        Matcher m = p.matcher(value);
        if (m.matches()) {
            LabelPosition lp = new LabelPosition();
            lp.setTargetAnchor(LabelPosition.convert(m.group(1)));
            lp.setLabelAnchor(LabelPosition.convert(m.group(2)));
            lp.setJustify(LabelPosition.convert(m.group(3)));
            lp.setOffsetX(Double.parseDouble(m.group(4)));
            lp.setOffsetY(Double.parseDouble(m.group(6)));
            return lp;
        }
        return null;
    }

    protected static String getShortName(int x) {
        switch (x) {
            case 1: {
                return nName;
            }
            case 7: {
                return sName;
            }
            case 5: {
                return eName;
            }
            case 3: {
                return wName;
            }
            case 0: {
                return nwName;
            }
            case 2: {
                return neName;
            }
            case 6: {
                return swName;
            }
            case 8: {
                return seName;
            }
            case 4: {
                return cName;
            }
            case 64: {
                return justifyCName;
            }
            case 65: {
                return justifyLName;
            }
            case 66: {
                return justifyRName;
            }
        }
        CyLogger.getLogger().info("don't recognize type: " + x);
        return "x";
    }
}

