/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.Appearance;
import cytoscape.visual.AppearanceCalculator;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyDependencyImpl;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.Node;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeAppearanceCalculator
extends AppearanceCalculator {
    private NodeAppearance defaultAppearance = new NodeAppearance();

    @Deprecated
    public NodeAppearanceCalculator() {
        super(new VisualPropertyDependencyImpl());
    }

    public NodeAppearanceCalculator(VisualPropertyDependency deps) {
        super(deps);
    }

    public NodeAppearanceCalculator(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog, VisualPropertyDependency deps) {
        super(name, nacProps, baseKey, catalog, new NodeAppearance(), deps);
        this.defaultAppearance = (NodeAppearance)this.tmpDefaultAppearance;
    }

    public NodeAppearanceCalculator(NodeAppearanceCalculator toCopy) {
        super(toCopy);
    }

    public NodeAppearance calculateNodeAppearance(Node node, CyNetwork network) {
        NodeAppearance appr = new NodeAppearance(this.deps);
        this.calculateNodeAppearance(appr, node, network, VisualPropertyType.getNodeVisualPropertyList());
        return appr;
    }

    @Override
    public Object clone() {
        NodeAppearanceCalculator copy = new NodeAppearanceCalculator(this.deps);
        NodeAppearance defAppr = new NodeAppearance();
        for (VisualPropertyType type : VisualPropertyType.getNodeVisualPropertyList()) {
            defAppr.set(type, this.defaultAppearance.get(type));
        }
        copy.setDefaultAppearance(defAppr);
        for (Calculator cal : this.calcs) {
            ObjectMapping mCopy = (ObjectMapping)cal.getMapping(0).clone();
            BasicCalculator bCalc = new BasicCalculator(((Object)cal).toString(), mCopy, cal.getVisualPropertyType());
            copy.setCalculator(bCalc);
        }
        return copy;
    }

    public void calculateNodeAppearance(NodeAppearance appr, Node node, CyNetwork network) {
        this.calculateNodeAppearance(appr, node, network, VisualPropertyType.getNodeVisualPropertyList());
    }

    void calculateNodeAppearance(NodeAppearance appr, Node node, CyNetwork network, List<VisualPropertyType> bypassedVPs) {
        appr.copy(this.defaultAppearance);
        for (Calculator nc : this.calcs) {
            nc.apply((Appearance)appr, node, network);
        }
        appr.applyBypass(node, bypassedVPs);
    }

    public NodeAppearance getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public void setDefaultAppearance(NodeAppearance n) {
        this.defaultAppearance = n;
    }

    public String getDescription() {
        return this.getDescription("NodeAppearanceCalculator", this.defaultAppearance);
    }

    public void applyProperties(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(this.defaultAppearance, name, nacProps, baseKey, catalog);
    }

    public Properties getProperties(String baseKey) {
        return this.getProperties(this.defaultAppearance, baseKey);
    }

    @Override
    protected void copyDefaultAppearance(AppearanceCalculator toCopy) {
        this.defaultAppearance = (NodeAppearance)((NodeAppearanceCalculator)toCopy).getDefaultAppearance().clone();
    }

    public boolean getNodeSizeLocked() {
        return this.deps.check(VisualPropertyDependency.Definition.NODE_SIZE_LOCKED);
    }

    public void setNodeSizeLocked(boolean b) {
        this.deps.set(VisualPropertyDependency.Definition.NODE_SIZE_LOCKED, b);
    }
}

