/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.logger.CyLogger;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyDependencyImpl;
import cytoscape.visual.calculators.Calculator;
import java.util.Vector;

public class VisualStyle
implements Cloneable {
    private String name = "default";
    private NodeAppearanceCalculator nodeAC;
    private EdgeAppearanceCalculator edgeAC;
    private GlobalAppearanceCalculator globalAC;
    private VisualPropertyDependency deps;
    protected int dupeCount = 0;

    public int getDupeCount() {
        return this.dupeCount;
    }

    public Vector checkConflictingCalculator(Calculator c) {
        Vector<String> conflicts = new Vector<String>();
        conflicts.add(this.name);
        for (Calculator nodeCalcs : this.nodeAC.getCalculators()) {
            if (nodeCalcs != c) continue;
            conflicts.add(nodeCalcs.getVisualPropertyType().getPropertyLabel());
        }
        for (Calculator edgeCalcs : this.edgeAC.getCalculators()) {
            if (edgeCalcs != c) continue;
            conflicts.add(edgeCalcs.getVisualPropertyType().getPropertyLabel());
        }
        return conflicts;
    }

    public Object clone() throws CloneNotSupportedException {
        int dupeCountIndex;
        VisualStyle copy = (VisualStyle)super.clone();
        String dupeFreeName = this.dupeCount != 0 ? ((dupeCountIndex = this.name.lastIndexOf(new Integer(this.dupeCount).toString())) == -1 ? new String(this.name) : this.name.substring(0, dupeCountIndex)) : new String(this.name);
        copy.name = dupeFreeName;
        ++copy.dupeCount;
        copy.nodeAC = (NodeAppearanceCalculator)this.nodeAC.clone();
        copy.edgeAC = (EdgeAppearanceCalculator)this.edgeAC.clone();
        copy.globalAC = (GlobalAppearanceCalculator)this.globalAC.clone();
        return copy;
    }

    public VisualStyle(String name) {
        this.deps = new VisualPropertyDependencyImpl();
        this.setName(name);
        this.setNodeAppearanceCalculator(new NodeAppearanceCalculator(this.deps));
        this.setEdgeAppearanceCalculator(new EdgeAppearanceCalculator(this.deps));
        this.setGlobalAppearanceCalculator(new GlobalAppearanceCalculator());
    }

    public VisualStyle(String name, NodeAppearanceCalculator nac, EdgeAppearanceCalculator eac, GlobalAppearanceCalculator gac) {
        this.deps = new VisualPropertyDependencyImpl();
        this.setName(name);
        this.setNodeAppearanceCalculator(nac);
        this.setEdgeAppearanceCalculator(eac);
        this.setGlobalAppearanceCalculator(gac);
    }

    public VisualStyle(VisualStyle toCopy) {
        this(toCopy, toCopy.getName());
    }

    public VisualStyle(VisualStyle toCopy, String newName) {
        if (toCopy == null) {
            return;
        }
        if (newName == null) {
            throw new NullPointerException("Unexpected null name in VisualStyle constructor");
        }
        this.deps = toCopy.getDependency();
        if (this.deps == null) {
            this.deps = new VisualPropertyDependencyImpl();
        }
        this.setName(newName);
        this.setNodeAppearanceCalculator((NodeAppearanceCalculator)toCopy.getNodeAppearanceCalculator().clone());
        this.setEdgeAppearanceCalculator((EdgeAppearanceCalculator)toCopy.getEdgeAppearanceCalculator().clone());
        try {
            this.setGlobalAppearanceCalculator((GlobalAppearanceCalculator)toCopy.getGlobalAppearanceCalculator().clone());
        }
        catch (CloneNotSupportedException e) {
            CyLogger.getLogger(VisualStyle.class).warn("Internal error - Unable to clone global appearance calculator!");
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String setName(String n) {
        String tmp = this.name;
        this.name = n;
        return tmp;
    }

    public NodeAppearanceCalculator getNodeAppearanceCalculator() {
        return this.nodeAC;
    }

    public NodeAppearanceCalculator setNodeAppearanceCalculator(NodeAppearanceCalculator nac) {
        NodeAppearanceCalculator tmp = this.nodeAC;
        this.nodeAC = nac == null ? new NodeAppearanceCalculator(this.deps) : nac;
        return tmp;
    }

    public EdgeAppearanceCalculator getEdgeAppearanceCalculator() {
        return this.edgeAC;
    }

    public EdgeAppearanceCalculator setEdgeAppearanceCalculator(EdgeAppearanceCalculator eac) {
        EdgeAppearanceCalculator tmp = this.edgeAC;
        this.edgeAC = eac == null ? new EdgeAppearanceCalculator(this.deps) : eac;
        return tmp;
    }

    public GlobalAppearanceCalculator getGlobalAppearanceCalculator() {
        return this.globalAC;
    }

    public GlobalAppearanceCalculator setGlobalAppearanceCalculator(GlobalAppearanceCalculator gac) {
        GlobalAppearanceCalculator tmp = this.globalAC;
        this.globalAC = gac == null ? new GlobalAppearanceCalculator() : gac;
        return tmp;
    }

    public VisualPropertyDependency getDependency() {
        return this.deps;
    }
}

