/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.ui;

import cytoscape.visual.customgraphic.CustomGraphicsUtil;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.swingx.JXImagePanel;

public class CustomGraphicsCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 8040076496780883222L;
    private static final int ICON_SIZE = 130;
    private static final int NAME_LENGTH_LIMIT = 24;
    private static final Color SELECTED = Color.red;
    private static final Color NOT_SELECTED = Color.darkGray;
    private static final Font LABEL_FONT = new Font("SansSerif", 0, 10);
    private static final Font SELECTED_LABEL_FONT = new Font("SansSerif", 1, 10);
    private static final Dimension CELL_SIZE = new Dimension(200, 150);
    private final Map<CyCustomGraphics, Component> panelMap = new HashMap<CyCustomGraphics, Component>();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel target = null;
        if (value != null && value instanceof CyCustomGraphics) {
            CyCustomGraphics cg = (CyCustomGraphics)value;
            target = (JPanel)this.panelMap.get(cg);
            if (target == null) {
                target = this.createImagePanel(cg, isSelected);
                this.panelMap.put(cg, target);
            }
            String name = cg.getDisplayName();
            target.setToolTipText(name);
            if (name.length() > 24) {
                name = name.substring(0, 24) + "...";
            }
            if (isSelected) {
                target.setBorder(new TitledBorder(new LineBorder(SELECTED), name, 2, 2, SELECTED_LABEL_FONT));
            } else {
                target.setBorder(new TitledBorder(new LineBorder(NOT_SELECTED), name, 2, 2, LABEL_FONT));
            }
        }
        return target;
    }

    private JPanel createImagePanel(CyCustomGraphics cg, boolean selected) {
        Image image = cg.getRenderedImage();
        if (image == null) {
            return this;
        }
        JXImagePanel imagePanel = new JXImagePanel();
        imagePanel.setPreferredSize(new Dimension(130, 130));
        imagePanel.setStyle(JXImagePanel.Style.CENTERED);
        if (image.getHeight(null) < 130 && image.getWidth(null) < 200) {
            imagePanel.setImage(image);
        } else {
            imagePanel.setImage(CustomGraphicsUtil.getResizedImage(image, null, 130, true));
        }
        imagePanel.setBorder(new TitledBorder(new LineBorder(Color.DARK_GRAY), cg.getDisplayName(), 2, 2, LABEL_FONT));
        imagePanel.setPreferredSize(CELL_SIZE);
        imagePanel.setBackground(Color.white);
        return imagePanel;
    }
}

