/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.logger.CyLogger;
import cytoscape.visual.mappings.RangeValueCalculator;
import cytoscape.visual.mappings.RangeValueCalculatorFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeValueCalculatorFactoryImpl
implements RangeValueCalculatorFactory {
    private final Map<Class<?>, RangeValueCalculator<?>> calcMap = new HashMap();
    private final Set<RangeValueCalculator<?>> calcs = new HashSet();
    private static final CyLogger logger = CyLogger.getLogger();

    @Override
    public <T extends RangeValueCalculator<?>> T getRangeValueCalculator(Class<?> type) {
        RangeValueCalculator<?> calc = this.calcMap.get(type);
        if (calc == null) {
            for (RangeValueCalculator<?> c : this.calcs) {
                if (!c.isCompatible(type)) continue;
                this.calcMap.put(type, c);
                calc = c;
                return (T)calc;
            }
        }
        logger.warn("Could not find RVC: " + calc);
        return (T)calc;
    }

    @Override
    public void registerRVC(RangeValueCalculator<?> rvc) {
        this.calcs.add(rvc);
    }
}

