/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.LegendTable;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.ui.editors.continuous.C2CMappingEditor;
import cytoscape.visual.ui.editors.continuous.C2DMappingEditor;
import cytoscape.visual.ui.editors.continuous.GradientEditorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class ContinuousLegend
extends JPanel {
    private static final Font TITLE_FONT2 = new Font("SansSerif", 1, 18);
    private static final Color TITLE_COLOR = new Color(10, 200, 255);
    private static final Border BORDER = new MatteBorder(0, 6, 3, 0, Color.DARK_GRAY);
    private List points;
    private VisualPropertyType type;
    private JLabel legend = null;
    int width = 40;
    int height;
    int yoff = this.height = 40;

    @Deprecated
    public ContinuousLegend(String dataAttr, List points, Object obj, VisualPropertyType vpt) {
        this(points, vpt);
    }

    public ContinuousLegend(List points, VisualPropertyType vpt) {
        this.points = points;
        this.type = vpt;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ContinuousLegend.this.setLegend(e);
            }
        });
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.setBorder(BORDER);
        JLabel title = new JLabel(" " + vpt.getName() + " Mapping");
        title.setFont(TITLE_FONT2);
        title.setForeground(TITLE_COLOR);
        title.setBorder(new MatteBorder(0, 10, 1, 0, TITLE_COLOR));
        title.setHorizontalTextPosition(10);
        title.setPreferredSize(new Dimension(1, 50));
        this.add((Component)title, "North");
        this.setLegend(null);
    }

    private void setLegend(ComponentEvent e) {
        if (this.legend != null) {
            this.remove(this.legend);
        }
        Integer trackW = null;
        if (this.getParent() == null) {
            trackW = 600;
        } else {
            trackW = ((Number)((double)this.getParent().getParent().getParent().getWidth() * 0.82)).intValue();
            if (trackW < 200) {
                trackW = 200;
            }
        }
        this.legend = this.type.getDataType() == Color.class ? new JLabel(GradientEditorPanel.getLegend(trackW, 100, this.type)) : (this.type.getDataType() == Number.class ? new JLabel(C2CMappingEditor.getLegend(trackW, 150, this.type)) : new JLabel(C2DMappingEditor.getLegend(trackW, 150, this.type)));
        this.legend.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add((Component)this.legend, "Center");
        this.repaint();
    }

    private JPanel getGradientPanel() {
        JPanel holder = new JPanel();
        holder.setLayout(new GridLayout(1, 2));
        holder.setAlignmentX(0.0f);
        holder.setBackground(Color.white);
        JLabel grad = new JLabel(this.getColorGradientIcon());
        grad.setAlignmentX(0.0f);
        holder.add(grad);
        JLabel num = new JLabel(this.getNumberGradientIcon());
        num.setAlignmentX(0.0f);
        holder.add(num);
        return holder;
    }

    private ImageIcon getNumberGradientIcon() {
        int imageHeight = (this.points.size() + 1) * this.height;
        BufferedImage bi = new BufferedImage(this.width, imageHeight, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, this.width, imageHeight);
        g2.setPaint(Color.black);
        int yoff = (int)((float)g2.getFontMetrics().getMaxAscent() / 2.0f);
        ContinuousMappingPoint curr = null;
        for (int i = 0; i < this.points.size(); ++i) {
            curr = (ContinuousMappingPoint)this.points.get(i);
            g2.drawString(curr.getValue().toString(), 0, (i + 1) * this.height + yoff);
        }
        return new ImageIcon(bi);
    }

    private ImageIcon getColorGradientIcon() {
        int imageHeight = (this.points.size() + 1) * this.height;
        BufferedImage bi = new BufferedImage(this.width, imageHeight, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, this.width, imageHeight);
        ContinuousMappingPoint curr = null;
        ContinuousMappingPoint next = null;
        Rectangle rect = new Rectangle(0, 0, this.width, this.height);
        for (int i = 0; i < this.points.size(); ++i) {
            curr = (ContinuousMappingPoint)this.points.get(i);
            next = i + 1 < this.points.size() ? (ContinuousMappingPoint)this.points.get(i + 1) : null;
            if (i == 0) {
                g2.setPaint((Color)curr.getRange().lesserValue);
                rect.setBounds(0, 0, this.width, this.height);
                g2.fill(rect);
            }
            if (next != null) {
                GradientPaint gp = new GradientPaint(0.0f, (i + 1) * this.height, (Color)curr.getRange().equalValue, 0.0f, (i + 2) * this.height, (Color)next.getRange().equalValue);
                g2.setPaint(gp);
                rect.setBounds(0, (i + 1) * this.height, this.width, this.height);
                g2.fill(rect);
                continue;
            }
            g2.setPaint((Color)curr.getRange().greaterValue);
            rect.setBounds(0, (i + 1) * this.height, this.width, this.height);
            g2.fill(rect);
        }
        return new ImageIcon(bi);
    }

    private JPanel getObjectPanel(VisualPropertyType vpt) {
        Object[][] data = new Object[this.points.size() + 2][2];
        ContinuousMappingPoint curr = null;
        for (int i = 0; i < this.points.size(); ++i) {
            curr = (ContinuousMappingPoint)this.points.get(i);
            if (i == 0) {
                data[i][0] = curr.getRange().lesserValue;
                data[i][1] = "< " + curr.getValue().toString();
            }
            data[i + 1][0] = curr.getRange().equalValue;
            data[i + 1][1] = "= " + curr.getValue().toString();
            if (i != this.points.size() - 1) continue;
            data[i + 2][0] = curr.getRange().greaterValue;
            data[i + 2][1] = "> " + curr.getValue().toString();
        }
        LegendTable lt = new LegendTable(data, vpt);
        return lt;
    }
}

