/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.mappings.continuous.ContinuousMappingReader;
import cytoscape.visual.parsers.ColorParser;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TestContinuousMappingReader
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReader() throws Exception {
        Properties properties;
        block3: {
            properties = new Properties();
            InputStream in = null;
            try {
                in = TestContinuousMappingReader.getDataFile();
                properties.load(in);
                Object var4_3 = null;
                if (in == null) break block3;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        int size = properties.size();
        TestContinuousMappingReader.assertEquals(17, size);
        ColorParser parser = new ColorParser();
        ContinuousMappingReader reader = new ContinuousMappingReader(properties, "nodeColorCalculator.RedGreen2.mapping", parser);
        String attrName = reader.getControllingAttributeName();
        TestContinuousMappingReader.assertEquals("expression", attrName);
        Interpolator interp = reader.getInterpolator();
        TestContinuousMappingReader.assertTrue(interp instanceof LinearNumberToColorInterpolator);
        List<ContinuousMappingPoint> points = reader.getPoints();
        TestContinuousMappingReader.assertEquals(3, points.size());
        ContinuousMappingPoint point0 = points.get(0);
        double value0 = point0.getValue();
        TestContinuousMappingReader.assertEquals(-1.0, value0, 1.0E-4);
        BoundaryRangeValues range0 = point0.getRange();
        TestContinuousMappingReader.assertEquals(Color.RED, range0.lesserValue);
        TestContinuousMappingReader.assertEquals(Color.RED, range0.equalValue);
        TestContinuousMappingReader.assertEquals(Color.RED, range0.greaterValue);
        ContinuousMappingPoint point1 = points.get(1);
        double value1 = point1.getValue();
        TestContinuousMappingReader.assertEquals(0.0, value1, 1.0E-4);
        BoundaryRangeValues range1 = point1.getRange();
        TestContinuousMappingReader.assertEquals(Color.WHITE, range1.lesserValue);
        TestContinuousMappingReader.assertEquals(Color.WHITE, range1.equalValue);
        TestContinuousMappingReader.assertEquals(Color.WHITE, range1.greaterValue);
    }

    static InputStream getDataFile() {
        String file = "nodeColorCalculator.RedGreen2.mapping.bv0.lesser:  255,0,0\nnodeColorCalculator.RedGreen2.mapping.interpolator:  LinearNumberToColorInterpolator\nnodeColorCalculator.RedGreen2.mapping.bv0.greater:  255,0,0\nnodeColorCalculator.RedGreen2.mapping.bv1.domainvalue:  0.0\nnodeColorCalculator.RedGreen2.class:  cytoscape.visual.calculators.GenericNodeColorCalculator\nnodeColorCalculator.RedGreen2.mapping.bv1.equal:  255,255,255\nnodeColorCalculator.RedGreen2.mapping.bv1.greater:  255,255,255\nnodeColorCalculator.RedGreen2.mapping.controller:  expression\nnodeColorCalculator.RedGreen2.mapping.boundaryvalues:  3\nnodeColorCalculator.RedGreen2.mapping.bv2.domainvalue:  0.0\nnodeColorCalculator.RedGreen2.mapping.bv0.domainvalue:  -1.0\nnodeColorCalculator.RedGreen2.mapping.bv2.lesser:  255,255,255\nnodeColorCalculator.RedGreen2.mapping.type:  ContinuousMapping\nnodeColorCalculator.RedGreen2.mapping.bv0.equal:  255,0,0\nnodeColorCalculator.RedGreen2.mapping.bv2.greater:  102,255,102\nnodeColorCalculator.RedGreen2.mapping.bv1.lesser:  255,255,255\nnodeColorCalculator.RedGreen2.mapping.bv2.equal:  255,255,255\n";
        ByteArrayInputStream in = new ByteArrayInputStream(file.getBytes());
        return in;
    }
}

