/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.parsers;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.customgraphic.CyCustomGraphicsParser;
import cytoscape.visual.customgraphic.CyCustomGraphicsParserFactory;
import cytoscape.visual.customgraphic.DefaultCyCustomGraphicsParser;
import cytoscape.visual.customgraphic.URLImageCustomGraphicsParser;
import cytoscape.visual.customgraphic.impl.CyCustomGraphicsParserFactoryImpl;
import cytoscape.visual.customgraphic.impl.bitmap.URLImageCustomGraphics;
import cytoscape.visual.parsers.ValueParser;
import java.io.IOException;
import java.net.URL;

public class GraphicsParser
implements ValueParser {
    private static final String NULL_CG = "cytoscape.visual.customgraphic.NullCustomGraphics";
    private static final CyLogger logger = CyLogger.getLogger();
    private final CyCustomGraphicsParserFactory parserFactory = new CyCustomGraphicsParserFactoryImpl();
    private final CyCustomGraphicsParser defaultParser;

    public GraphicsParser() {
        this.parserFactory.registerParser(URLImageCustomGraphics.class, new URLImageCustomGraphicsParser());
        this.defaultParser = new DefaultCyCustomGraphicsParser();
    }

    public CyCustomGraphics parseStringValue(String value) {
        return this.parse(value);
    }

    private CyCustomGraphics parse(String value) {
        if (value == null || value.equals(NULL_CG)) {
            return null;
        }
        try {
            URL url = new URL(value);
            CyCustomGraphics graphics = Cytoscape.getVisualMappingManager().getCustomGraphicsManager().getBySourceURL(url);
            if (graphics == null) {
                graphics = new URLImageCustomGraphics(url.toString());
                graphics.setDisplayName(value);
                Cytoscape.getVisualMappingManager().getCustomGraphicsManager().addGraphics(graphics, url);
            }
            return graphics;
        }
        catch (IOException e) {
            String[] parts = value.split(",");
            if (parts.length < 4) {
                return null;
            }
            String className = parts[0];
            CyCustomGraphicsParser parser = this.parserFactory.getParser(className);
            if (parser == null) {
                return this.defaultParser.getInstance(value);
            }
            return parser.getInstance(value);
        }
    }
}

