/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.parsers;

import cytoscape.visual.parsers.ValueParser;
import ding.view.ObjectPositionImpl;
import giny.view.Justification;
import giny.view.ObjectPosition;
import giny.view.Position;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectPositionParser
implements ValueParser {
    private static final Pattern P = Pattern.compile("^([NSEWC]{1,2}+),([NSEWC]{1,2}+),([clr]{1}+),(-?\\d+(.\\d+)?),(-?\\d+(.\\d+)?)$");

    public ObjectPosition parseStringValue(String value) {
        return this.parse(value);
    }

    private ObjectPosition parse(String value) {
        Matcher m = P.matcher(value);
        if (m.matches()) {
            ObjectPositionImpl p = new ObjectPositionImpl();
            p.setTargetAnchor(Position.parse(m.group(1)));
            p.setAnchor(Position.parse(m.group(2)));
            p.setJustify(Justification.parse(m.group(3)));
            p.setOffsetX(Double.parseDouble(m.group(4)));
            p.setOffsetY(Double.parseDouble(m.group(6)));
            return p;
        }
        return null;
    }
}

