/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualProperty;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.freehep.util.export.ExportDialog;

public class LegendDialog
extends JDialog {
    private VisualStyle visualStyle;
    private JPanel jPanel1;
    private JButton jButton1;
    private JButton jButton2;
    private JScrollPane jScrollPane1;
    private Component parent;

    public LegendDialog(Dialog parent, VisualStyle vs) {
        super(parent, true);
        this.visualStyle = vs;
        this.parent = parent;
        this.initComponents();
    }

    public LegendDialog(JFrame parent, VisualStyle vs) {
        super((Frame)parent, true);
        this.visualStyle = vs;
        this.parent = parent;
        this.initComponents();
    }

    public static JPanel generateLegendPanel(VisualStyle visualStyle) {
        JPanel mleg;
        ObjectMapping om;
        JPanel legend = new JPanel();
        NodeAppearanceCalculator nac = visualStyle.getNodeAppearanceCalculator();
        List nodeCalcs = nac.getCalculators();
        EdgeAppearanceCalculator eac = visualStyle.getEdgeAppearanceCalculator();
        List edgeCalcs = eac.getCalculators();
        legend.setLayout(new BoxLayout(legend, 1));
        legend.setBackground(Color.white);
        legend.setBorder(new TitledBorder(new LineBorder(Color.DARK_GRAY, 2), "Visual Legend for " + visualStyle.getName(), 0, 2, new Font("SansSerif", 1, 16), Color.DARK_GRAY));
        for (Calculator calc : nodeCalcs) {
            VisualProperty vp = calc.getVisualPropertyType().getVisualProperty();
            if (vp.constrained(visualStyle.getDependency())) continue;
            om = calc.getMapping(0);
            mleg = om.getLegend(calc.getVisualPropertyType());
            if (om instanceof PassThroughMapping) {
                legend.add((Component)mleg, 0);
            } else {
                legend.add(mleg);
            }
            mleg.setBorder(new EmptyBorder(15, 30, 15, 30));
        }
        int top = legend.getComponentCount();
        for (Calculator calc : edgeCalcs) {
            om = calc.getMapping(0);
            mleg = om.getLegend(calc.getVisualPropertyType());
            if (om instanceof PassThroughMapping) {
                legend.add((Component)mleg, 0);
            } else {
                legend.add(mleg);
            }
            mleg.setBorder(new EmptyBorder(15, 30, 15, 30));
        }
        return legend;
    }

    private void initComponents() {
        this.setTitle("Visual Legend for " + this.visualStyle.getName());
        this.jPanel1 = LegendDialog.generateLegendPanel(this.visualStyle);
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jButton1 = new JButton();
        this.jButton1.setText("Export");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LegendDialog.this.export();
            }
        });
        this.jButton2 = new JButton();
        this.jButton2.setText("Done");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LegendDialog.this.dispose();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.jButton1);
        buttonPanel.add(this.jButton2);
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 1));
        containerPanel.add(this.jScrollPane1);
        containerPanel.add(buttonPanel);
        this.setContentPane(containerPanel);
        this.setPreferredSize(new Dimension(650, 500));
        this.pack();
        this.repaint();
    }

    private void export() {
        ExportDialog export = new ExportDialog();
        export.showExportDialog(this.parent, "Export legend as ...", this.jPanel1, "export");
        this.dispose();
    }
}

