/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.ui.FontChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class PopupFontChooser
extends JDialog {
    private Font font;
    private FontChooser chooser;

    public static Font showDialog(Frame f, Font begin) {
        PopupFontChooser fpc = new PopupFontChooser(f, begin);
        fpc.setModal(true);
        fpc.setAlwaysOnTop(true);
        return fpc.getThisFont();
    }

    public static Font showDialog(Dialog f, Font begin) {
        PopupFontChooser fpc = new PopupFontChooser(f, begin);
        fpc.setModal(true);
        fpc.setAlwaysOnTop(true);
        return fpc.getThisFont();
    }

    private PopupFontChooser(Frame parent, Font begin) {
        super(parent, true);
        this.init(parent, begin);
    }

    private PopupFontChooser(Dialog parent, Font begin) {
        super(parent, true);
        this.init(parent, begin);
    }

    private void init(Component parent, Font begin) {
        this.setTitle("Please select a font...");
        this.font = begin;
        this.chooser = this.font == null ? new FontChooser() : new FontChooser(begin.deriveFont(1.0f));
        JPanel butPanel = new JPanel(false);
        JButton okBut = new JButton("OK");
        okBut.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PopupFontChooser.this.font = PopupFontChooser.this.chooser.getSelectedFont().deriveFont(12.0f);
                PopupFontChooser.this.dispose();
            }
        });
        JButton cancelBut = new JButton("Cancel");
        cancelBut.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PopupFontChooser.this.dispose();
            }
        });
        butPanel.add(okBut);
        butPanel.add(cancelBut);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.chooser, "Center");
        content.add((Component)butPanel, "South");
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private Font getThisFont() {
        return this.font;
    }
}

