/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.ui.ObjectPlacerGraphic;
import cytoscape.visual.ui.editors.continuous.EditorValueRangeTracer;
import cytoscape.visual.ui.editors.continuous.VizMapperTrackRenderer;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import giny.view.ObjectPosition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteTrackRenderer<T>
extends JComponent
implements VizMapperTrackRenderer {
    private static final long serialVersionUID = 5024551458030362213L;
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 12);
    private static final int ICON_SIZE = 32;
    private static final int ICON_SIZE_CG = 50;
    private static final Color ICON_COLOR = new Color(10, 100, 255, 200);
    private static final int THUMB_WIDTH = 12;
    private static final int V_PADDING = 20;
    private int trackHeight = 70;
    private int arrowBarYPosition = this.trackHeight + 50;
    private int smallIconSize = 20;
    private T below;
    private T above;
    private final VisualPropertyType type;
    private String title;
    private List<T> rangeObjects;
    private JXMultiThumbSlider<T> slider;

    public DiscreteTrackRenderer(VisualPropertyType type, T below, T above) {
        this.below = below;
        this.above = above;
        this.type = type;
        this.title = type.isNodeProp() ? Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getCalculator(type).getMapping(0).getControllingAttributeName() : Cytoscape.getVisualMappingManager().getVisualStyle().getEdgeAppearanceCalculator().getCalculator(type).getMapping(0).getControllingAttributeName();
        this.setBackground(Color.white);
        this.setForeground(Color.white);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintComponent(g);
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        int iconLocY;
        int iconLocX;
        this.trackHeight = this.slider.getHeight() - 100;
        this.arrowBarYPosition = this.trackHeight + 50;
        Graphics2D g = (Graphics2D)gfx;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int track_width = this.slider.getWidth() - 12;
        g.translate(6, 12);
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        double valueRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        List<Thumb<T>> stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Object[] objectValues = new Object[numPoints];
        int i = 0;
        for (Thumb<T> thumb : stops) {
            objectValues[i] = thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        g.drawLine(0, this.arrowBarYPosition, track_width, this.arrowBarYPosition);
        Polygon arrow = new Polygon();
        arrow.addPoint(track_width, this.arrowBarYPosition);
        arrow.addPoint(track_width - 20, this.arrowBarYPosition - 8);
        arrow.addPoint(track_width - 20, this.arrowBarYPosition);
        g.fill(arrow);
        g.setColor(Color.gray);
        g.drawLine(0, this.arrowBarYPosition, 15, this.arrowBarYPosition - 30);
        g.drawLine(15, this.arrowBarYPosition - 30, 25, this.arrowBarYPosition - 30);
        g.setFont(SMALL_FONT);
        g.drawString("Min=" + minValue, 28, this.arrowBarYPosition - 25);
        g.drawLine(track_width, this.arrowBarYPosition, track_width - 15, this.arrowBarYPosition + 30);
        g.drawLine(track_width - 15, this.arrowBarYPosition + 30, track_width - 25, this.arrowBarYPosition + 30);
        String maxStr = "Max=" + maxValue;
        int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
        g.drawString(maxStr, track_width - strWidth - 26, this.arrowBarYPosition + 35);
        g.setFont(SMALL_FONT);
        g.setColor(Color.black);
        strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
        g.drawString(this.title, track_width / 2 - strWidth / 2, this.arrowBarYPosition + 35);
        if (numPoints == 0) {
            g.setColor(BORDER_COLOR);
            g.setStroke(new BasicStroke(1.5f));
            g.drawRect(0, 5, track_width, this.trackHeight);
            return;
        }
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.white);
        g.fillRect(0, 5, track_width, this.trackHeight);
        this.rangeObjects = DiscreteTrackRenderer.buildIconArray(stops.size() + 1);
        int newX = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 5.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 5.0f);
        int iconSize = this.type.getDataType().equals(CyCustomGraphics.class) ? 50 : 32;
        for (i = 0; i < stops.size(); ++i) {
            newX = (int)((float)track_width * (fractions[i] / 100.0f));
            ((Point2D)p2).setLocation(newX, 5.0);
            g.setColor(Color.black);
            g.setStroke(STROKE1);
            g.drawLine(newX, 5, newX, this.trackHeight + 4);
            g.setColor(Color.DARK_GRAY);
            g.setFont(new Font("SansSerif", 1, 10));
            Float curPositionValue = Float.valueOf(((Number)((double)(fractions[i] / 100.0f) * valueRange + minValue)).floatValue());
            String valueString = String.format("%.5f", curPositionValue);
            int flipLimit = 90;
            int borderVal = track_width - newX;
            if (i % 2 == 0 && flipLimit < borderVal) {
                g.drawLine(newX, this.arrowBarYPosition, newX + 20, this.arrowBarYPosition - 15);
                g.drawLine(newX + 20, this.arrowBarYPosition - 15, newX + 30, this.arrowBarYPosition - 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX + 33, this.arrowBarYPosition - 11);
            } else if (i % 2 == 1 && flipLimit < borderVal) {
                g.drawLine(newX, this.arrowBarYPosition, newX + 20, this.arrowBarYPosition + 15);
                g.drawLine(newX + 20, this.arrowBarYPosition + 15, newX + 30, this.arrowBarYPosition + 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX + 33, this.arrowBarYPosition + 19);
            } else if (i % 2 == 0 && flipLimit >= borderVal) {
                g.drawLine(newX, this.arrowBarYPosition, newX - 20, this.arrowBarYPosition - 15);
                g.drawLine(newX - 20, this.arrowBarYPosition - 15, newX - 30, this.arrowBarYPosition - 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX - 90, this.arrowBarYPosition - 11);
            } else {
                g.drawLine(newX, this.arrowBarYPosition, newX - 20, this.arrowBarYPosition + 15);
                g.drawLine(newX - 20, this.arrowBarYPosition + 15, newX - 30, this.arrowBarYPosition + 15);
                g.setColor(Color.black);
                g.drawString(valueString, newX - 90, this.arrowBarYPosition + 19);
            }
            g.setColor(Color.black);
            g.fillOval(newX - 3, this.arrowBarYPosition - 3, 6, 6);
            iconLocX = newX - ((newX - (int)((Point2D)p1).getX()) / 2 + iconSize / 2);
            iconLocY = this.trackHeight / 2 - iconSize / 2 + 5;
            if (i == 0) {
                this.drawIcon(this.below, g, iconLocX, iconLocY, iconSize);
            } else {
                this.drawIcon(objectValues[i], g, iconLocX, iconLocY, iconSize);
            }
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(track_width, 5.0);
        iconLocX = track_width - ((track_width - (int)((Point2D)p1).getX()) / 2 + iconSize / 2);
        iconLocY = this.trackHeight / 2 - iconSize / 2 + 5;
        this.drawIcon(this.above, g, iconLocX, iconLocY, iconSize);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.5f));
        g.drawRect(0, 5, track_width, this.trackHeight);
        g.translate(-6, -12);
    }

    @Override
    public JComponent getRendererComponent(JXMultiThumbSlider slider) {
        this.slider = slider;
        return this;
    }

    public String getToolTipForCurrentLocation(int x, int y) {
        int oldX = 0;
        List<Thumb<T>> stops = this.slider.getModel().getSortedThumbs();
        int i = 1;
        for (Thumb<T> thumb : stops) {
            int newX = (int)((float)this.slider.getWidth() * (thumb.getPosition() / 100.0f));
            if (oldX <= x && x <= newX && 20 < y && y < 20 + this.trackHeight) {
                return "This is region " + i;
            }
            ++i;
            oldX = newX + 1;
        }
        if (oldX <= x && x <= this.slider.getWidth() && 20 < y && y < 20 + this.trackHeight) {
            return "Last Area: " + oldX + " - " + this.slider.getWidth() + " (x, y) = " + x + ", " + y;
        }
        return null;
    }

    public Object getObjectInRange(int x, int y) {
        int range = this.getRangeID(x, y);
        if (range == -1) {
            return null;
        }
        if (range == 0) {
            return null;
        }
        if (range == this.slider.getModel().getThumbCount()) {
            // empty if block
        }
        return this.rangeObjects.get(this.getRangeID(x, y));
    }

    protected int getRangeID(int x, int y) {
        int i;
        int oldX = 0;
        List<Thumb<T>> stops = this.slider.getModel().getSortedThumbs();
        for (i = 0; i < stops.size(); ++i) {
            Thumb<T> thumb = stops.get(i);
            int newX = (int)((float)this.slider.getWidth() * (thumb.getPosition() / 100.0f));
            if (oldX <= x && x <= newX && 20 < y && y < 20 + this.trackHeight) {
                return i;
            }
            oldX = newX + 1;
        }
        if (oldX <= x && x <= this.slider.getWidth() && 20 < y && y < 20 + this.trackHeight) {
            return i;
        }
        return -1;
    }

    public static ImageIcon getTrackGraphicIcon(int iconWidth, int iconHeight, ContinuousMapping mapping) {
        BufferedImage bi = new BufferedImage(iconWidth, iconHeight, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int leftSpace = 2;
        int trackHeight = iconHeight - 15;
        int trackWidth = iconWidth - 2 - 5;
        g2.setBackground(Color.white);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, iconWidth, iconHeight);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.black);
        List<ContinuousMappingPoint> points = mapping.getAllPoints();
        int pointCount = points.size();
        if (pointCount == 0) {
            g2.drawRect(2, 0, trackWidth, trackHeight);
            return new ImageIcon(bi);
        }
        Object[] objValues = new Object[pointCount + 2];
        objValues[0] = points.get((int)0).getRange().lesserValue;
        if (pointCount == 1) {
            objValues[1] = points.get((int)0).getRange().equalValue;
            objValues[2] = points.get((int)0).getRange().greaterValue;
        } else {
            objValues[objValues.length - 1] = points.get((int)(points.size() - 1)).getRange().greaterValue;
            for (int i = 0; i < pointCount; ++i) {
                objValues[i + 1] = points.get((int)i).getRange().equalValue;
            }
        }
        return new ImageIcon(bi);
    }

    private static List buildIconArray(int size) {
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        Map<Object, Icon> iconMap = NodeShape.getIconSet();
        Object[] keys = iconMap.keySet().toArray();
        for (int i = 0; i < size; ++i) {
            icons.add((ImageIcon)iconMap.get(keys[i]));
        }
        return icons;
    }

    private void drawIcon(Object key, Graphics2D g, int x, int y, int size) {
        if (key == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.translate(x, y);
        g.setColor(ICON_COLOR);
        g.setStroke(STROKE2);
        switch (this.type) {
            case NODE_SHAPE: {
                VisualPropertyIcon icon = (VisualPropertyIcon)this.type.getVisualProperty().getIconSet().get(key);
                icon.setIconHeight(size);
                icon.setIconWidth(size);
                g.fill(icon.getShape());
                break;
            }
            case EDGE_SRCARROW_SHAPE: 
            case EDGE_TGTARROW_SHAPE: {
                VisualPropertyIcon arrowIcon = (VisualPropertyIcon)this.type.getVisualProperty().getIconSet().get(key);
                if (arrowIcon == null) break;
                int newSize = size;
                arrowIcon.setIconHeight(newSize);
                arrowIcon.setIconWidth(((Number)((double)newSize * 2.5)).intValue());
                g.translate(-newSize, 0);
                arrowIcon.paintIcon(this, g, x, y);
                g.translate(newSize, 0);
                break;
            }
            case NODE_FONT_FACE: 
            case EDGE_FONT_FACE: {
                Font font = (Font)key;
                String fontName = font.getFontName();
                g.setFont(new Font(fontName, font.getStyle(), size));
                g.drawString("A", 0, size);
                int smallFontSize = ((Number)((double)size * 0.25)).intValue();
                g.setFont(new Font(fontName, font.getStyle(), smallFontSize));
                int stringWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), fontName);
                g.drawString(fontName, size / 2 - stringWidth / 2, size + smallFontSize + 2);
                break;
            }
            case NODE_LINE_STYLE: 
            case EDGE_LINE_STYLE: {
                Stroke stroke = ((LineStyle)((Object)key)).getStroke(2.0f);
                int newSize2 = (int)((double)size * 1.5);
                g.translate(0.0, (double)(-size) * 0.25);
                g.setColor(Color.DARK_GRAY);
                g.drawRect(0, 0, size, newSize2);
                g.setStroke(stroke);
                g.setColor(ICON_COLOR);
                g.drawLine(size - 1, 1, 1, newSize2 - 1);
                g.translate(0.0, (double)size * 0.25);
                break;
            }
        }
        if (this.type.getDataType().equals(ObjectPosition.class)) {
            ObjectPlacerGraphic lp = new ObjectPlacerGraphic((ObjectPosition)key, (int)((double)size * 1.5), false, this.type.getName(), null, null);
            lp.paint(g);
        } else if (this.type.getDataType().equals(CyCustomGraphics.class)) {
            CyCustomGraphics cg = (CyCustomGraphics)key;
            Image rendered = cg.getRenderedImage();
            if (rendered != null) {
                g.drawImage(rendered, 0, 0, size, size, null);
            }
        } else {
            g.drawString(key.toString(), 0, g.getFont().getSize() * 2);
        }
        g.translate(-x, -y);
    }

    public ImageIcon getTrackGraphicIcon(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, false);
    }

    public ImageIcon getLegend(int iconWidth, int iconHeight) {
        return this.drawIcon(iconWidth, iconHeight, true);
    }

    private ImageIcon drawIcon(int iconWidth, int iconHeight, boolean detail) {
        int iconLocY;
        int iconLocX;
        int trackHeight;
        if (this.slider == null) {
            return null;
        }
        BufferedImage bi = new BufferedImage(iconWidth, iconHeight, 1);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(Color.white);
        g.fillRect(0, 0, iconWidth, iconHeight);
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        double valueRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        int track_width = iconWidth;
        if (detail) {
            trackHeight = iconHeight - 30;
            this.smallIconSize = (int)((double)trackHeight * 0.5);
        } else {
            trackHeight = iconHeight - 8;
        }
        List<Thumb<T>> stops = this.slider.getModel().getSortedThumbs();
        int numPoints = stops.size();
        float[] fractions = new float[numPoints];
        Object[] objectValues = new Object[numPoints];
        int i = 0;
        for (Thumb<T> thumb : stops) {
            objectValues[i] = thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        if (numPoints == 0) {
            g.setColor(BORDER_COLOR);
            g.setStroke(new BasicStroke(1.0f));
            g.drawRect(0, 0, track_width - 3, trackHeight);
            return new ImageIcon(bi);
        }
        this.rangeObjects = DiscreteTrackRenderer.buildIconArray(stops.size() + 1);
        int newX = 0;
        Point2D.Float p1 = new Point2D.Float(0.0f, 5.0f);
        Point2D.Float p2 = new Point2D.Float(0.0f, 5.0f);
        for (i = 0; i < stops.size(); ++i) {
            newX = (int)((float)track_width * (fractions[i] / 100.0f));
            ((Point2D)p2).setLocation(newX, 0.0);
            iconLocX = newX - ((newX - (int)((Point2D)p1).getX()) / 2 + this.smallIconSize / 2);
            iconLocY = trackHeight / 2 - this.smallIconSize / 2;
            if (i == 0) {
                this.drawIcon(this.below, g, iconLocX, iconLocY, this.smallIconSize);
            } else {
                this.drawIcon(objectValues[i], g, iconLocX, iconLocY, this.smallIconSize);
            }
            g.setColor(Color.DARK_GRAY);
            g.setStroke(STROKE1);
            g.drawLine(newX, 0, newX, trackHeight);
            p1.setLocation(p2);
        }
        ((Point2D)p2).setLocation(track_width, 0.0);
        iconLocX = track_width - ((track_width - (int)((Point2D)p1).getX()) / 2 + this.smallIconSize / 2);
        iconLocY = trackHeight / 2 - this.smallIconSize / 2;
        this.drawIcon(this.above, g, iconLocX, iconLocY, this.smallIconSize);
        g.setColor(BORDER_COLOR);
        g.setStroke(new BasicStroke(1.0f));
        g.drawRect(0, 0, track_width - 3, trackHeight);
        g.setFont(new Font("SansSerif", 1, 9));
        String minStr = String.format("%.2f", minValue);
        String maxStr = String.format("%.2f", maxValue);
        g.setColor(Color.black);
        if (detail) {
            int strWidth;
            String fNum = null;
            for (int j = 0; j < fractions.length; ++j) {
                fNum = String.format("%.2f", (double)(fractions[j] / 100.0f) * valueRange + minValue);
                strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), fNum);
                g.drawString(fNum, fractions[j] / 100.0f * (float)iconWidth - (float)(strWidth / 2), (float)(iconHeight - 20));
            }
            g.drawString(minStr, 0, iconHeight);
            strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
            g.setFont(TITLE_FONT);
            int titleWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), this.title);
            g.setColor(Color.black);
            g.drawString(this.title, iconWidth / 2 - titleWidth / 2, iconHeight - 5);
            Polygon p = new Polygon();
            p.addPoint(iconWidth, iconHeight - 9);
            p.addPoint(iconWidth - 15, iconHeight - 15);
            p.addPoint(iconWidth - 15, iconHeight - 9);
            g.fillPolygon(p);
            g.drawLine(0, iconHeight - 9, iconWidth / 2 - titleWidth / 2 - 3, iconHeight - 9);
            g.drawLine(iconWidth / 2 + titleWidth / 2 + 3, iconHeight - 9, iconWidth, iconHeight - 9);
        } else {
            g.drawString(minStr, 0, iconHeight);
            int strWidth = SwingUtilities.computeStringWidth(g.getFontMetrics(), maxStr);
            g.drawString(maxStr, iconWidth - strWidth - 2, iconHeight);
        }
        return new ImageIcon(bi);
    }

    public Double getSelectedThumbValue() {
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double valueRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        float position = this.slider.getModel().getThumbAt(this.slider.getSelectedIndex()).getPosition();
        return (double)(position / 100.0f) * valueRange + minValue;
    }
}

