/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.ThumbRenderer;

public class TriangleThumbRenderer
extends JComponent
implements ThumbRenderer {
    private static final Color SELECTED_COLOR = Color.red;
    private static final Color DEFAULT_COLOR = Color.DARK_GRAY;
    private static final Color BACKGROUND_COLOR = Color.white;
    private JXMultiThumbSlider slider;
    private boolean selected;

    public TriangleThumbRenderer(JXMultiThumbSlider slider) {
        this.slider = slider;
        this.setBackground(BACKGROUND_COLOR);
    }

    protected void paintComponent(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.selected) {
            Polygon outline = new Polygon();
            outline.addPoint(0, 0);
            outline.addPoint(0, 4);
            outline.addPoint(4, 9);
            outline.addPoint(8, 4);
            outline.addPoint(8, 0);
            g.fillPolygon(outline);
            g.setColor(Color.blue);
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            g.drawPolygon(outline);
        } else {
            Polygon thumb = new Polygon();
            thumb.addPoint(0, 0);
            thumb.addPoint(10, 0);
            thumb.addPoint(5, 10);
            g.fillPolygon(thumb);
            Polygon outline = new Polygon();
            outline.addPoint(0, 0);
            outline.addPoint(9, 0);
            outline.addPoint(5, 9);
            g.setColor(Color.DARK_GRAY);
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            g.drawPolygon(outline);
        }
    }

    public JComponent getThumbRendererComponent(JXMultiThumbSlider slider, int index, boolean selected) {
        this.selected = selected;
        Object obj = slider.getModel().getThumbAt(index).getObject();
        if (obj.getClass() == Color.class) {
            this.setForeground((Color)obj);
        } else if (selected) {
            this.setForeground(SELECTED_COLOR);
        } else {
            this.setForeground(DEFAULT_COLOR);
        }
        return this;
    }
}

