/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.graph.fixed.FixedGraph;
import cytoscape.render.immed.EdgeAnchors;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntIterator;
import cytoscape.util.intr.IntObjHash;
import cytoscape.util.intr.MinIntHeap;
import ding.view.DEdgeView;
import ding.view.DGraphView;
import ding.view.IntermediateEdgeDetails;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.HashMap;

class DEdgeDetails
extends IntermediateEdgeDetails {
    final DGraphView m_view;
    final IntObjHash m_colorsLowDetail = new IntObjHash();
    final Object m_deletedEntry = new Object();
    final HashMap m_segmentThicknesses = new HashMap();
    final HashMap m_segmentStrokes = new HashMap();
    final HashMap m_sourceArrows = new HashMap();
    final HashMap m_sourceArrowPaints = new HashMap();
    final HashMap m_targetArrows = new HashMap();
    final HashMap m_targetArrowPaints = new HashMap();
    final HashMap m_segmentPaints = new HashMap();
    final HashMap m_labelCounts = new HashMap();
    final HashMap m_labelTexts = new HashMap();
    final HashMap m_labelFonts = new HashMap();
    final HashMap m_labelPaints = new HashMap();
    final HashMap m_labelWidths = new HashMap();
    private final MinIntHeap m_heap = new MinIntHeap();
    private final float[] m_extentsBuff = new float[4];

    DEdgeDetails(DGraphView view) {
        this.m_view = view;
    }

    void unregisterEdge(int edge) {
        Object o = this.m_colorsLowDetail.get(edge);
        if (o != null && o != this.m_deletedEntry) {
            this.m_colorsLowDetail.put(edge, this.m_deletedEntry);
        }
        Integer key = new Integer(edge);
        this.m_segmentThicknesses.remove(key);
        this.m_segmentStrokes.remove(key);
        this.m_sourceArrows.remove(key);
        this.m_sourceArrowPaints.remove(key);
        this.m_targetArrows.remove(key);
        this.m_targetArrowPaints.remove(key);
        this.m_segmentPaints.remove(key);
        this.m_labelCounts.remove(key);
        this.m_labelTexts.remove(key);
        this.m_labelFonts.remove(key);
        this.m_labelPaints.remove(key);
        this.m_labelWidths.remove(key);
    }

    public Color colorLowDetail(int edge) {
        Object o = this.m_colorsLowDetail.get(edge);
        if (o == null || o == this.m_deletedEntry) {
            return super.colorLowDetail(edge);
        }
        return (Color)o;
    }

    void overrideColorLowDetail(int edge, Color color) {
        if (color == null || color.equals(super.colorLowDetail(edge))) {
            Object val = this.m_colorsLowDetail.get(edge);
            if (val != null && val != this.m_deletedEntry) {
                this.m_colorsLowDetail.put(edge, this.m_deletedEntry);
            }
        } else {
            this.m_colorsLowDetail.put(edge, color);
        }
    }

    public byte sourceArrow(int edge) {
        Object o = this.m_sourceArrows.get(new Integer(edge));
        if (o == null) {
            return super.sourceArrow(edge);
        }
        return (Byte)o;
    }

    void overrideSourceArrow(int edge, byte arrowType) {
        if (arrowType >= 0 || arrowType == super.sourceArrow(edge)) {
            this.m_sourceArrows.remove(new Integer(edge));
        } else {
            this.m_sourceArrows.put(new Integer(edge), new Byte(arrowType));
        }
    }

    public Paint sourceArrowPaint(int edge) {
        Object o = this.m_sourceArrowPaints.get(new Integer(edge));
        if (o == null) {
            return super.sourceArrowPaint(edge);
        }
        return (Paint)o;
    }

    void overrideSourceArrowPaint(int edge, Paint paint) {
        if (paint == null || paint.equals(super.sourceArrowPaint(edge))) {
            this.m_sourceArrowPaints.remove(new Integer(edge));
        } else {
            this.m_sourceArrowPaints.put(new Integer(edge), paint);
        }
    }

    public byte targetArrow(int edge) {
        Object o = this.m_targetArrows.get(new Integer(edge));
        if (o == null) {
            return super.targetArrow(edge);
        }
        return (Byte)o;
    }

    void overrideTargetArrow(int edge, byte arrowType) {
        if (arrowType >= 0 || arrowType == super.targetArrow(edge)) {
            this.m_targetArrows.remove(new Integer(edge));
        } else {
            this.m_targetArrows.put(new Integer(edge), new Byte(arrowType));
        }
    }

    public Paint targetArrowPaint(int edge) {
        Object o = this.m_targetArrowPaints.get(new Integer(edge));
        if (o == null) {
            return super.targetArrowPaint(edge);
        }
        return (Paint)o;
    }

    void overrideTargetArrowPaint(int edge, Paint paint) {
        if (paint == null || paint.equals(super.targetArrowPaint(edge))) {
            this.m_targetArrowPaints.remove(new Integer(edge));
        } else {
            this.m_targetArrowPaints.put(new Integer(edge), paint);
        }
    }

    public EdgeAnchors anchors(int edge) {
        int trgNode;
        EdgeAnchors returnThis = (EdgeAnchors)((Object)this.m_view.getEdgeView(~edge));
        if (returnThis.numAnchors() > 0) {
            return returnThis;
        }
        FixedGraph graph = (FixedGraph)((Object)this.m_view.m_drawPersp);
        int srcNode = graph.edgeSource(edge);
        if (srcNode == (trgNode = graph.edgeTarget(edge))) {
            int e2;
            this.m_view.m_spacial.exists(srcNode, this.m_extentsBuff, 0);
            double w = (double)this.m_extentsBuff[2] - (double)this.m_extentsBuff[0];
            double h = (double)this.m_extentsBuff[3] - (double)this.m_extentsBuff[1];
            final double x = ((double)this.m_extentsBuff[0] + (double)this.m_extentsBuff[2]) / 2.0;
            final double y = ((double)this.m_extentsBuff[1] + (double)this.m_extentsBuff[3]) / 2.0;
            final double nodeSize = Math.max(w, h);
            int i = 0;
            IntIterator selfEdges = graph.edgesConnecting(srcNode, srcNode, true, true, true);
            while (selfEdges.hasNext() && (e2 = selfEdges.nextInt()) != edge) {
                if (((EdgeAnchors)((Object)this.m_view.getEdgeView(~e2))).numAnchors() != 0) continue;
                ++i;
            }
            final int inx = i;
            return new EdgeAnchors(){

                public int numAnchors() {
                    return 2;
                }

                public void getAnchor(int anchorInx, float[] anchorArr, int offset) {
                    if (anchorInx == 0) {
                        anchorArr[offset] = (float)(x - (double)(inx + 3) * nodeSize / 2.0);
                        anchorArr[offset + 1] = (float)y;
                    } else if (anchorInx == 1) {
                        anchorArr[offset] = (float)x;
                        anchorArr[offset + 1] = (float)(y - (double)(inx + 3) * nodeSize / 2.0);
                    }
                }
            };
        }
        int tmpSrc = Math.min(srcNode, trgNode);
        int tmpTrg = Math.max(srcNode, trgNode);
        IntIterator conEdges = graph.edgesConnecting(tmpSrc, tmpTrg, true, true, true);
        this.m_heap.empty();
        while (conEdges.hasNext()) {
            this.m_heap.toss(conEdges.nextInt());
        }
        IntEnumerator otherEdges = this.m_heap.orderedElements(false);
        int otherEdge = otherEdges.nextInt();
        if (otherEdge != edge) {
            int i;
            int n = i = ((EdgeAnchors)((Object)this.m_view.getEdgeView(~otherEdge))).numAnchors() == 0 ? 1 : 0;
            while (edge != (otherEdge = otherEdges.nextInt())) {
                if (((EdgeAnchors)((Object)this.m_view.getEdgeView(~otherEdge))).numAnchors() != 0) continue;
                ++i;
            }
            int inx = i;
            this.m_view.m_spacial.exists(tmpSrc, this.m_extentsBuff, 0);
            double srcW = (double)this.m_extentsBuff[2] - (double)this.m_extentsBuff[0];
            double srcH = (double)this.m_extentsBuff[3] - (double)this.m_extentsBuff[1];
            double srcX = ((double)this.m_extentsBuff[0] + (double)this.m_extentsBuff[2]) / 2.0;
            double srcY = ((double)this.m_extentsBuff[1] + (double)this.m_extentsBuff[3]) / 2.0;
            this.m_view.m_spacial.exists(tmpTrg, this.m_extentsBuff, 0);
            double trgW = (double)this.m_extentsBuff[2] - (double)this.m_extentsBuff[0];
            double trgH = (double)this.m_extentsBuff[3] - (double)this.m_extentsBuff[1];
            double trgX = ((double)this.m_extentsBuff[0] + (double)this.m_extentsBuff[2]) / 2.0;
            double trgY = ((double)this.m_extentsBuff[1] + (double)this.m_extentsBuff[3]) / 2.0;
            double nodeSize = Math.max(Math.max(Math.max(srcW, srcH), trgW), trgH);
            double midX = (srcX + trgX) / 2.0;
            double midY = (srcY + trgY) / 2.0;
            double dx = trgX - srcX;
            double dy = trgY - srcY;
            double len = Math.sqrt(dx * dx + dy * dy);
            if ((float)len != 0.0f) {
                double offset = (double)((inx + 1) / 2 * (inx % 2 == 0 ? 1 : -1)) * nodeSize;
                double normX = dx / len;
                double normY = dy / len;
                final double anchorX = midX + offset * normY;
                final double anchorY = midY - offset * normX;
                return new EdgeAnchors(){

                    public int numAnchors() {
                        return 1;
                    }

                    public void getAnchor(int inx, float[] arr, int off) {
                        arr[off] = (float)anchorX;
                        arr[off + 1] = (float)anchorY;
                    }
                };
            }
        }
        return returnThis;
    }

    public float anchorSize(int edge, int anchorInx) {
        if (this.m_view.getEdgeView(~edge).isSelected() && ((DEdgeView)this.m_view.getEdgeView(~edge)).numAnchors() > 0) {
            return this.m_view.getAnchorSize();
        }
        return 0.0f;
    }

    public Paint anchorPaint(int edge, int anchorInx) {
        if (((DEdgeView)this.m_view.getEdgeView((int)(edge ^ 0xFFFFFFFF))).m_lineType == 2) {
            anchorInx /= 2;
        }
        if (this.m_view.m_selectedAnchors.count(edge << 6 | anchorInx) > 0) {
            return this.m_view.getAnchorSelectedPaint();
        }
        return this.m_view.getAnchorUnselectedPaint();
    }

    public float segmentThickness(int edge) {
        Object o = this.m_segmentThicknesses.get(new Integer(edge));
        if (o == null) {
            return super.segmentThickness(edge);
        }
        return ((Float)o).floatValue();
    }

    void overrideSegmentThickness(int edge, float thickness) {
        if (thickness < 0.0f || thickness == super.segmentThickness(edge)) {
            this.m_segmentThicknesses.remove(new Integer(edge));
        } else {
            this.m_segmentThicknesses.put(new Integer(edge), new Float(thickness));
        }
    }

    public Stroke segmentStroke(int edge) {
        Object o = this.m_segmentStrokes.get(new Integer(edge));
        if (o == null) {
            return super.segmentStroke(edge);
        }
        return (Stroke)o;
    }

    void overrideSegmentStroke(int edge, Stroke stroke) {
        if (stroke == null || stroke.equals(super.segmentStroke(edge))) {
            this.m_segmentStrokes.remove(new Integer(edge));
        } else {
            this.m_segmentStrokes.put(new Integer(edge), stroke);
        }
    }

    public Paint segmentPaint(int edge) {
        Object o = this.m_segmentPaints.get(new Integer(edge));
        if (o == null) {
            return super.segmentPaint(edge);
        }
        return (Paint)o;
    }

    void overrideSegmentPaint(int edge, Paint paint) {
        if (paint == null || paint == super.segmentPaint(edge)) {
            this.m_segmentPaints.remove(new Integer(edge));
        } else {
            this.m_segmentPaints.put(new Integer(edge), paint);
        }
    }

    public int labelCount(int edge) {
        Object o = this.m_labelCounts.get(new Integer(edge));
        if (o == null) {
            return super.labelCount(edge);
        }
        return (Integer)o;
    }

    void overrideLabelCount(int edge, int labelCount) {
        if (labelCount < 0 || labelCount == super.labelCount(edge)) {
            this.m_labelCounts.remove(new Integer(edge));
        } else {
            this.m_labelCounts.put(new Integer(edge), new Integer(labelCount));
        }
    }

    public String labelText(int edge, int labelInx) {
        long key = (long)edge << 32 | (long)labelInx;
        Object o = this.m_labelTexts.get(new Long(key));
        if (o == null) {
            return super.labelText(edge, labelInx);
        }
        return (String)o;
    }

    void overrideLabelText(int edge, int labelInx, String text) {
        long key = (long)edge << 32 | (long)labelInx;
        if (text == null || text.equals(super.labelText(edge, labelInx))) {
            this.m_labelTexts.remove(new Long(key));
        } else {
            this.m_labelTexts.put(new Long(key), text);
        }
    }

    public Font labelFont(int edge, int labelInx) {
        long key = (long)edge << 32 | (long)labelInx;
        Object o = this.m_labelFonts.get(new Long(key));
        if (o == null) {
            return super.labelFont(edge, labelInx);
        }
        return (Font)o;
    }

    void overrideLabelFont(int edge, int labelInx, Font font) {
        long key = (long)edge << 32 | (long)labelInx;
        if (font == null || font.equals(super.labelFont(edge, labelInx))) {
            this.m_labelFonts.remove(new Long(key));
        } else {
            this.m_labelFonts.put(new Long(key), font);
        }
    }

    public Paint labelPaint(int edge, int labelInx) {
        long key = (long)edge << 32 | (long)labelInx;
        Object o = this.m_labelPaints.get(new Long(key));
        if (o == null) {
            return super.labelPaint(edge, labelInx);
        }
        return (Paint)o;
    }

    void overrideLabelPaint(int edge, int labelInx, Paint paint) {
        long key = (long)edge << 32 | (long)labelInx;
        if (paint == null || paint.equals(super.labelPaint(edge, labelInx))) {
            this.m_labelPaints.remove(new Long(key));
        } else {
            this.m_labelPaints.put(new Long(key), paint);
        }
    }

    public float sourceArrowSize(int edge) {
        byte arrowType = this.sourceArrow(edge);
        if (arrowType == -6 || arrowType == -7) {
            return this.segmentThickness(edge) * 5.0f;
        }
        return this.segmentThickness(edge) + 5.0f;
    }

    public float targetArrowSize(int edge) {
        byte arrowType = this.targetArrow(edge);
        if (arrowType == -6 || arrowType == -7) {
            return this.segmentThickness(edge) * 5.0f;
        }
        return this.segmentThickness(edge) + 5.0f;
    }

    public double labelWidth(int edge) {
        Object o = this.m_labelWidths.get(new Integer(edge));
        if (o == null) {
            return super.labelWidth(edge);
        }
        return (Double)o;
    }

    void overrideLabelWidth(int edge, double width) {
        if (width < 0.0 || width == super.labelWidth(edge)) {
            this.m_labelWidths.remove(new Integer(edge));
        } else {
            this.m_labelWidths.put(new Integer(edge), new Double(width));
        }
    }
}

