/*
 * Decompiled with CFR 0.152.
 */
package ding.view.test;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

class LWButton01
extends Component {
    String rawLabel;
    String label;
    boolean pressed = false;
    boolean gotFocus = false;
    ActionListener actionListener;

    public LWButton01() {
        this("");
    }

    public LWButton01(String rawLabel) {
        this.rawLabel = rawLabel;
        this.label = "  " + rawLabel + "  ";
        this.enableEvents(28L);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    public void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyChar() == ' ') {
            this.processMouseEvent(new MouseEvent(this, 501, 0L, 0, 0, 0, 0, false));
        }
        if (e.getID() == 402 && e.getKeyChar() == ' ') {
            this.processMouseEvent(new MouseEvent(this, 502, 0L, 0, 0, 0, 0, false));
        }
        super.processKeyEvent(e);
    }

    public void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            this.gotFocus = true;
        }
        if (e.getID() == 1005) {
            this.gotFocus = false;
        }
        this.invalidate();
        this.repaint();
        super.processFocusEvent(e);
    }

    public void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                this.pressed = true;
                this.invalidate();
                this.repaint();
                break;
            }
            case 502: {
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
                }
                if (!this.pressed) break;
                this.pressed = false;
                this.requestFocus();
                this.invalidate();
                this.repaint();
            }
        }
        super.processMouseEvent(e);
    }

    public Dimension getPreferredSize() {
        if (this.getFont() != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            return new Dimension(fm.stringWidth(this.label), fm.getHeight() + 10);
        }
        return new Dimension(10, 10);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public String getLabel() {
        return this.rawLabel;
    }

    public void setLabel(String rawLabel) {
        this.rawLabel = rawLabel;
        this.label = "  " + rawLabel + "  ";
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.gotFocus) {
            g.setFont(new Font(this.getFont().getName(), 3, this.getFont().getSize()));
        } else {
            g.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
        }
        if (this.pressed) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(this.getBackground().darker().darker().darker());
            g.drawRect(0, 0, this.getSize().width, this.getSize().height);
            g.drawRect(1, 1, this.getSize().width, this.getSize().height);
            g.drawRect(2, 2, this.getSize().width, this.getSize().height);
            g.setColor(this.getBackground().darker());
            g.drawRect(-1, -1, this.getSize().width, this.getSize().height);
            FontMetrics fm = this.getFontMetrics(this.getFont());
            g.setColor(this.getForeground());
            g.drawString(this.label, this.getSize().width / 2 - fm.stringWidth(this.label) / 2, this.getSize().height / 2 + fm.getAscent() / 2);
        } else {
            g.setColor(this.getBackground().brighter());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(this.getBackground().darker().darker().darker());
            g.drawRect(-1, -1, this.getSize().width, this.getSize().height);
            g.drawRect(-2, -2, this.getSize().width, this.getSize().height);
            g.setColor(this.getBackground().brighter().brighter());
            g.drawRect(0, 0, this.getSize().width, this.getSize().height);
            FontMetrics fm = this.getFontMetrics(this.getFont());
            g.setColor(this.getForeground());
            g.drawString(this.label, this.getSize().width / 2 - fm.stringWidth(this.label) / 2 - 2, this.getSize().height / 2 + fm.getAscent() / 2 - 2);
        }
    }
}

