/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.FilePreview;
import jas.util.JASEditableComboBox;
import jas.util.UserProperties;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class OpenLocalFilePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private String m_lastLocalDirectory_Key;
    private JASEditableComboBox m_fileName;
    private JButton m_browse;
    private JButton m_view = null;
    private JCheckBox m_gzip = null;
    private final UserProperties m_prop = UserProperties.getUserProperties();
    private FileFilter m_filter = null;

    public OpenLocalFilePanel(boolean includePreviewButton, boolean includeGZIP, String key, FileFilter filter) {
        this(includePreviewButton, includeGZIP, key);
        this.m_filter = filter;
    }

    public OpenLocalFilePanel(boolean includePreviewButton, boolean includeGZIP, String key) {
        this.m_lastLocalDirectory_Key = key + "-directory";
        this.m_fileName = new JASEditableComboBox(key + "-files", 4, true);
        this.m_fileName.addChangeListener(this);
        this.m_fileName.setMinWidth(250);
        this.m_fileName.setMaxWidth(250);
        this.add(this.m_fileName);
        this.m_browse = new JButton("Browse...");
        this.m_browse.addActionListener(this);
        this.m_browse.setMnemonic('B');
        this.add(this.m_browse);
        if (includePreviewButton) {
            this.m_view = new JButton("Preview");
            this.m_view.addActionListener(this);
            this.m_view.setMnemonic('V');
            this.add(this.m_view);
            this.m_view.setEnabled(false);
        }
        if (includeGZIP) {
            this.m_gzip = new JCheckBox("GZIPed");
            this.m_gzip.addActionListener(this);
            this.m_gzip.setMnemonic('Z');
            this.add(this.m_gzip);
            this.m_gzip.setEnabled(false);
        }
        this.setBorder(BorderFactory.createTitledBorder("Enter the data file name"));
        this.setViewEnabled();
    }

    public void addChangeListener(ChangeListener cl) {
        this.m_fileName.addChangeListener(cl);
    }

    public void addActionListener(ActionListener al) {
        this.m_fileName.addActionListener(al);
    }

    public final void stateChanged(ChangeEvent e) {
        this.setViewEnabled();
    }

    private void setViewEnabled() {
        boolean enable;
        String text = this.m_fileName.getText();
        boolean bl = enable = text.length() > 0;
        if (this.m_view != null) {
            this.m_view.setEnabled(enable);
        }
        if (this.m_gzip != null) {
            this.m_gzip.setEnabled(enable);
            this.m_gzip.setSelected(text.endsWith(".gz"));
        }
    }

    public final void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_browse) {
            JFileChooser dlg = new JFileChooser(this.m_prop.getString(this.m_lastLocalDirectory_Key, System.getProperty("user.home")));
            dlg.setDialogTitle("Select a file");
            if (this.m_filter != null) {
                dlg.setFileFilter(this.m_filter);
            }
            if (dlg.showDialog(this, "Select") == 0) {
                File file = dlg.getSelectedFile();
                this.m_fileName.setText(file.getAbsolutePath());
                this.m_prop.setString(this.m_lastLocalDirectory_Key, file.getParent());
            }
        } else if (source == this.m_view) {
            try {
                Container c = this;
                while (!(c instanceof Frame)) {
                    c = c.getParent();
                }
                new FilePreview((Frame)c, new File(this.m_fileName.getText()), this.m_gzip == null ? false : this.m_gzip.isSelected());
            }
            catch (Exception x) {
                JOptionPane.showMessageDialog(this, x instanceof FileNotFoundException ? "File not found" : "Could not read file", "Error...", 0);
            }
        }
    }

    public String getText() {
        String fileName = this.m_fileName.getText();
        return fileName;
    }

    public void saveState() {
        this.m_fileName.saveState();
    }

    public boolean getGZIPed() {
        return this.m_gzip == null ? false : this.m_gzip.isSelected();
    }
}

