/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.AbstractLocationDecorator;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;

public class MergeLocation
extends RangeLocation {
    List componentLocations;

    private MergeLocation(int min, int max, List componentLocations) {
        super(min, max);
        this.componentLocations = componentLocations;
    }

    public List getComponentList(boolean recurse) {
        if (!recurse) {
            return this.componentLocations;
        }
        ArrayList l = new ArrayList();
        Iterator i = this.componentLocations.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof AbstractLocationDecorator) {
                o = ((AbstractLocationDecorator)o).getWrapped();
            }
            if (o instanceof MergeLocation) {
                List ll = ((MergeLocation)o).getComponentList(true);
                l.addAll(ll);
                continue;
            }
            l.add(o);
        }
        return l;
    }

    public ListIterator componentLocationIterator() {
        return this.componentLocations.listIterator();
    }

    public static MergeLocation mergeLocations(List componentLocations) throws BioException {
        Collections.sort(componentLocations, Location.naturalOrder);
        int lastMax = -1;
        int lastMin = -1;
        int min = Integer.MAX_VALUE;
        int max = 0;
        Iterator i = componentLocations.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (!(item instanceof Location)) {
                throw new BioException("All members of the component locations list must be Location objects");
            }
            Location loc = (Location)item;
            if (lastMin != -1 && lastMax != -1 && loc.getMin() + 1 > lastMax) {
                throw new BioException("All members of the component locations list must be contiguous");
            }
            if (loc.getMin() < min) {
                min = loc.getMin();
            }
            if (loc.getMax() > max) {
                max = loc.getMax();
            }
            lastMin = loc.getMin();
            lastMax = loc.getMax();
        }
        return new MergeLocation(min, max, componentLocations);
    }

    public static MergeLocation mergeLocations(Location locA, Location locB) throws BioException {
        int min = Math.min(locA.getMin(), locB.getMin());
        int max = Math.max(locA.getMax(), locB.getMax());
        ArrayList<Location> l = new ArrayList<Location>(2);
        l.add(locA);
        l.add(locB);
        return new MergeLocation(min, max, l);
    }
}

