/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations;

import java.util.Map;
import java.util.Stack;
import org.cytoscape.equations.CodeAndSourceLocation;
import org.cytoscape.equations.EqnParser;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.Parser;
import org.cytoscape.equations.parse_tree.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqnCompiler {
    private EqnParser parser = Parser.getParser();
    private Equation equation;
    private String errorMsg;

    public boolean compile(String equation, Map<String, Class> attribNameToTypeMap) {
        this.equation = null;
        this.errorMsg = null;
        if (!this.parser.parse(equation, attribNameToTypeMap)) {
            this.errorMsg = this.parser.getErrorMsg();
            return false;
        }
        Node parseTree = this.parser.getParseTree();
        Stack<CodeAndSourceLocation> codeStack = new Stack<CodeAndSourceLocation>();
        try {
            parseTree.genCode(codeStack);
        }
        catch (IllegalStateException e) {
            this.errorMsg = e.getCause().toString();
            return false;
        }
        Object[] code = new Object[codeStack.size()];
        int[] sourceLocations = new int[codeStack.size()];
        for (int i = code.length - 1; i >= 0; --i) {
            CodeAndSourceLocation codeAndSourceLocation = codeStack.pop();
            code[i] = codeAndSourceLocation.getCode();
            sourceLocations[i] = codeAndSourceLocation.getSourceLocation();
        }
        this.equation = new Equation(equation, this.parser.getVariableReferences(), code, sourceLocations, this.parser.getType());
        this.errorMsg = null;
        return true;
    }

    public String getLastErrorMsg() {
        return this.errorMsg;
    }

    public Equation getEquation() {
        return this.equation;
    }
}

