/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.equations.FunctionUtil;

public class ATan2
extends AbstractFunction {
    public ATan2() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.FLOAT, "x", "An x coordinate."), new ArgDescriptor(ArgType.FLOAT, "y", "A y coordinate.")});
    }

    public String getName() {
        return "ATAN2";
    }

    public String getFunctionSummary() {
        return "Returns the arctangent of two coordinates.";
    }

    public Class getReturnType() {
        return Double.class;
    }

    public Object evaluateFunction(Object[] args) {
        double x = FunctionUtil.getArgAsDouble(args[0]);
        double y = FunctionUtil.getArgAsDouble(args[1]);
        if (x == 0.0 && y == 0.0) {
            throw new IllegalArgumentException("both arguments to ATAN2() must not simultaneously be equal to zero!");
        }
        return Math.atan2(x, y);
    }
}

