/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.interpreter;

import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;
import org.cytoscape.equations.BooleanList;
import org.cytoscape.equations.DoubleList;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.FunctionError;
import org.cytoscape.equations.LongList;
import org.cytoscape.equations.StringList;
import org.cytoscape.equations.interpreter.IdentDescriptor;
import org.cytoscape.equations.interpreter.Instruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private final Object[] code;
    private final int[] sourceLocations;
    private final Stack<Object> argumentStack;
    private final Map<String, IdentDescriptor> nameToDescriptorMap;

    public Interpreter(Equation equation, Map<String, IdentDescriptor> nameToDescriptorMap) throws IllegalStateException {
        if (equation == null || equation.getCode().length == 0) {
            throw new IllegalStateException("null or empty code!");
        }
        this.code = equation.getCode();
        this.sourceLocations = equation.getSourceLocations();
        this.argumentStack = new Stack();
        this.nameToDescriptorMap = nameToDescriptorMap;
    }

    public Object run() throws ArithmeticException, IllegalArgumentException, IllegalStateException {
        int index = -1;
        try {
            block40: for (index = 0; index < this.code.length; ++index) {
                Object instrOrArg = this.code[index];
                if (instrOrArg instanceof Instruction) {
                    switch ((Instruction)((Object)instrOrArg)) {
                        case FADD: {
                            this.fadd();
                            continue block40;
                        }
                        case FSUB: {
                            this.fsub();
                            continue block40;
                        }
                        case FMUL: {
                            this.fmul();
                            continue block40;
                        }
                        case FDIV: {
                            this.fdiv();
                            continue block40;
                        }
                        case FPOW: {
                            this.fpow();
                            continue block40;
                        }
                        case SCONCAT: {
                            this.sconcat();
                            continue block40;
                        }
                        case BEQLF: {
                            this.beqlf();
                            continue block40;
                        }
                        case BNEQLF: {
                            this.bneqlf();
                            continue block40;
                        }
                        case BGTF: {
                            this.bgtf();
                            continue block40;
                        }
                        case BLTF: {
                            this.bltf();
                            continue block40;
                        }
                        case BGTEF: {
                            this.bgtef();
                            continue block40;
                        }
                        case BLTEF: {
                            this.bltef();
                            continue block40;
                        }
                        case BEQLS: {
                            this.beqls();
                            continue block40;
                        }
                        case BNEQLS: {
                            this.bneqls();
                            continue block40;
                        }
                        case BGTS: {
                            this.bgts();
                            continue block40;
                        }
                        case BLTS: {
                            this.blts();
                            continue block40;
                        }
                        case BGTES: {
                            this.bgtes();
                            continue block40;
                        }
                        case BLTES: {
                            this.bltes();
                            continue block40;
                        }
                        case BGTB: {
                            this.bgtb();
                            continue block40;
                        }
                        case BLTB: {
                            this.bltb();
                            continue block40;
                        }
                        case BGTEB: {
                            this.bgteb();
                            continue block40;
                        }
                        case BLTEB: {
                            this.blteb();
                            continue block40;
                        }
                        case BEQLB: {
                            this.beqlb();
                            continue block40;
                        }
                        case BNEQLB: {
                            this.bneqlb();
                            continue block40;
                        }
                        case CALL: {
                            this.call();
                            continue block40;
                        }
                        case FUMINUS: {
                            this.fuminus();
                            continue block40;
                        }
                        case FUPLUS: {
                            this.fuplus();
                            continue block40;
                        }
                        case AREF: {
                            this.aref();
                            continue block40;
                        }
                        case AREF2: {
                            this.aref2();
                            continue block40;
                        }
                        case FCONVI: {
                            this.fconvi();
                            continue block40;
                        }
                        case FCONVB: {
                            this.fconvb();
                            continue block40;
                        }
                        case FCONVS: {
                            this.fconvs();
                            continue block40;
                        }
                        case SCONVF: {
                            this.sconvf();
                            continue block40;
                        }
                        case SCONVI: {
                            this.sconvi();
                            continue block40;
                        }
                        case SCONVB: {
                            this.sconvb();
                            continue block40;
                        }
                        default: {
                            throw new IllegalStateException("unknown opcode: " + instrOrArg + "!");
                        }
                    }
                }
                this.argumentStack.push(instrOrArg);
            }
        }
        catch (EmptyStackException e) {
            throw new IllegalStateException("inconsistent number of stack entries detected!");
        }
        catch (FunctionError e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (this.argumentStack.size() != 1) {
            throw new IllegalStateException("invalid argument stack size " + this.argumentStack.size() + ", must be 1!");
        }
        Object retVal = this.argumentStack.peek();
        Class<?> retValClass = retVal.getClass();
        if (retValClass == Double.class || retValClass == String.class || retValClass == Boolean.class || retValClass == Long.class || retValClass == DoubleList.class || retValClass == BooleanList.class || retValClass == LongList.class || retValClass == StringList.class) {
            return retVal;
        }
        throw new IllegalStateException("illegal result type at end of interpretation: " + retValClass + "!");
    }

    private void fadd() throws EmptyStackException {
        double float1 = this.getFloat(this.argumentStack.pop());
        double float2 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 + float2);
    }

    private void fsub() throws EmptyStackException {
        double float1 = this.getFloat(this.argumentStack.pop());
        double float2 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 - float2);
    }

    private void fmul() throws EmptyStackException {
        double float1 = this.getFloat(this.argumentStack.pop());
        double float2 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 * float2);
    }

    private void fdiv() throws EmptyStackException, ArithmeticException {
        double float1 = this.getFloat(this.argumentStack.pop());
        double float2 = this.getFloat(this.argumentStack.pop());
        if (float2 == 0.0) {
            throw new ArithmeticException("illegal division by zero!");
        }
        this.argumentStack.push(float1 / float2);
    }

    private void fpow() throws EmptyStackException {
        double float1 = this.getFloat(this.argumentStack.pop());
        double float2 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(Math.pow(float1, float2));
    }

    private void sconcat() throws EmptyStackException {
        String string1 = this.getString(this.argumentStack.pop());
        String string2 = this.getString(this.argumentStack.pop());
        this.argumentStack.push(string1 + string2);
    }

    private void beqlf() throws EmptyStackException {
        double float2;
        double float1 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 == (float2 = this.getFloat(this.argumentStack.pop())));
    }

    private void bneqlf() throws EmptyStackException {
        double float2;
        double float1 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 != (float2 = this.getFloat(this.argumentStack.pop())));
    }

    private void bltf() throws EmptyStackException {
        double float2;
        double float1 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 < (float2 = this.getFloat(this.argumentStack.pop())));
    }

    private void bgtf() throws EmptyStackException {
        double float2;
        double float1 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 > (float2 = this.getFloat(this.argumentStack.pop())));
    }

    private void bltef() throws EmptyStackException {
        double float2;
        double float1 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 <= (float2 = this.getFloat(this.argumentStack.pop())));
    }

    private void bgtef() throws EmptyStackException {
        double float2;
        double float1 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1 >= (float2 = this.getFloat(this.argumentStack.pop())));
    }

    private void beqls() throws EmptyStackException {
        String string1 = this.getString(this.argumentStack.pop());
        String string2 = this.getString(this.argumentStack.pop());
        this.argumentStack.push(string1.equals(string2));
    }

    private void bneqls() throws EmptyStackException {
        String string2;
        String string1 = this.getString(this.argumentStack.pop());
        this.argumentStack.push(!string1.equals(string2 = this.getString(this.argumentStack.pop())));
    }

    private void blts() throws EmptyStackException {
        String string2;
        String string1 = this.getString(this.argumentStack.pop());
        this.argumentStack.push(string1.compareTo(string2 = this.getString(this.argumentStack.pop())) < 0);
    }

    private void bgts() throws EmptyStackException {
        String string2;
        String string1 = this.getString(this.argumentStack.pop());
        this.argumentStack.push(string1.compareTo(string2 = this.getString(this.argumentStack.pop())) > 0);
    }

    private void bltes() throws EmptyStackException {
        String string2;
        String string1 = this.getString(this.argumentStack.pop());
        this.argumentStack.push(string1.compareTo(string2 = this.getString(this.argumentStack.pop())) <= 0);
    }

    private void bgtes() throws EmptyStackException {
        String string2;
        String string1 = this.getString(this.argumentStack.pop());
        this.argumentStack.push(string1.compareTo(string2 = this.getString(this.argumentStack.pop())) >= 0);
    }

    private void bgtb() throws EmptyStackException {
        boolean bool1 = this.getBoolean(this.argumentStack.pop());
        boolean bool2 = this.getBoolean(this.argumentStack.pop());
        this.argumentStack.push(bool1 && !bool2);
    }

    private void bltb() throws EmptyStackException {
        boolean bool1 = this.getBoolean(this.argumentStack.pop());
        boolean bool2 = this.getBoolean(this.argumentStack.pop());
        this.argumentStack.push(!bool1 && bool2);
    }

    private void bgteb() throws EmptyStackException {
        boolean bool1 = this.getBoolean(this.argumentStack.pop());
        boolean bool2 = this.getBoolean(this.argumentStack.pop());
        this.argumentStack.push(bool1 && !bool2 || bool1 == bool2);
    }

    private void blteb() throws EmptyStackException {
        boolean bool1 = this.getBoolean(this.argumentStack.pop());
        boolean bool2 = this.getBoolean(this.argumentStack.pop());
        this.argumentStack.push(!bool1 && bool2 || bool1 == bool2);
    }

    private void beqlb() throws EmptyStackException {
        boolean bool2;
        boolean bool1 = this.getBoolean(this.argumentStack.pop());
        this.argumentStack.push(bool1 == (bool2 = this.getBoolean(this.argumentStack.pop())));
    }

    private void bneqlb() throws EmptyStackException {
        boolean bool2;
        boolean bool1 = this.getBoolean(this.argumentStack.pop());
        this.argumentStack.push(bool1 != (bool2 = this.getBoolean(this.argumentStack.pop())));
    }

    private void call() throws EmptyStackException, IllegalStateException, FunctionError {
        int argCount;
        Object o = this.argumentStack.pop();
        if (!(o instanceof Function)) {
            throw new IllegalStateException("expected an attribute function after the CALL opcode but found \"" + o.getClass() + "\" instead!");
        }
        Function func = (Function)o;
        try {
            argCount = (Integer)this.argumentStack.pop();
        }
        catch (Exception e) {
            throw new IllegalStateException("invalid argument count type following a CALL opcode!");
        }
        boolean MIN_ARG_COUNT = false;
        int MAX_ARG_COUNT = 100;
        if (argCount < 0 || argCount > 100) {
            throw new IllegalStateException("invalid argument count type following a CALL opcode (range must be in [0, 100])!");
        }
        Object[] args = new Object[argCount];
        for (int argNo = 0; argNo < argCount; ++argNo) {
            args[argNo] = this.argumentStack.pop();
        }
        this.argumentStack.push(func.evaluateFunction(args));
    }

    private void fuminus() throws EmptyStackException {
        double float1 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(-float1);
    }

    private void fuplus() throws EmptyStackException {
        double float1 = this.getFloat(this.argumentStack.pop());
        this.argumentStack.push(float1);
    }

    private void aref() throws EmptyStackException {
        String attribName = (String)this.argumentStack.pop();
        IdentDescriptor identDescriptor = this.nameToDescriptorMap.get(attribName);
        if (identDescriptor == null) {
            throw new IllegalStateException("unknown attribute reference: \"" + attribName + "\" (1)!");
        }
        Object value = identDescriptor.getValue();
        if (value == null) {
            throw new IllegalStateException("undefined attribute reference: \"" + attribName + "\"!");
        }
        this.argumentStack.push(value);
    }

    private void aref2() throws EmptyStackException {
        String attribName = (String)this.argumentStack.pop();
        Object defaultValue = this.argumentStack.pop();
        IdentDescriptor identDescriptor = this.nameToDescriptorMap.get(attribName);
        if (identDescriptor == null) {
            throw new IllegalStateException("unknown attribute reference: \"" + attribName + "\" (2)!");
        }
        Object value = identDescriptor.getValue();
        this.argumentStack.push(value != null ? value : defaultValue);
    }

    private void fconvi() throws EmptyStackException {
        Long long1 = this.getLong(this.argumentStack.pop());
        this.argumentStack.push(long1);
    }

    private void fconvb() throws EmptyStackException {
        Boolean b = this.getBoolean(this.argumentStack.pop());
        this.argumentStack.push(b != false ? 1.0 : 0.0);
    }

    private void fconvs() throws EmptyStackException {
        String s = this.getString(this.argumentStack.pop());
        try {
            this.argumentStack.push(Double.parseDouble(s));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("can't convert \"" + s + "\" to a number!");
        }
    }

    private void sconvf() throws EmptyStackException {
        this.argumentStack.push(this.argumentStack.pop().toString());
    }

    private void sconvi() throws EmptyStackException {
        this.argumentStack.push(this.argumentStack.pop().toString());
    }

    private void sconvb() throws EmptyStackException {
        this.argumentStack.pop();
        this.argumentStack.push("\uffff\uffff\uffff");
    }

    private double getFloat(Object o) throws IllegalStateException {
        if (o instanceof Double) {
            return (Double)o;
        }
        throw new IllegalStateException("can't convert a " + o.getClass() + " (" + o + ") to a floating point number!");
    }

    private long getLong(Object o) throws IllegalStateException {
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new IllegalStateException("can't convert a " + o.getClass() + " (" + o + ") to an integer number!");
    }

    private String getString(Object o) throws IllegalStateException {
        if (o instanceof String) {
            return (String)o;
        }
        throw new IllegalStateException("can't convert a " + o.getClass() + " to a string!");
    }

    private boolean getBoolean(Object o) throws IllegalStateException {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalStateException("can't convert a " + o.getClass() + " to a boolean!");
    }
}

