### R code from vignette source 'MiRaGE.Rnw'

###################################################
### code chunk number 1: MiRaGE.Rnw:122-126
###################################################
library(MiRaGE)
data(gene_exp)
library(Biobase)
result <- MiRaGE(gene_exp,location="web",species="HS")


###################################################
### code chunk number 2: MiRaGE.Rnw:140-142
###################################################
data(gene_exp)
gene_exp


###################################################
### code chunk number 3: MiRaGE.Rnw:167-169
###################################################
x_gene <- read.csv(system.file("extdata/x_all_7a.csv",package="MiRaGE"),sep="\t")
x_gene[101:103,]


###################################################
### code chunk number 4: MiRaGE.Rnw:175-178
###################################################
gene_exp <- new("ExpressionSet",expr=data.matrix(x_gene[,-1]))
fData(gene_exp)[["gene_id"]] <- x_gene[,1]
pData(gene_exp)[["sample_name"]] <- colnames(x_gene)[-1]


###################################################
### code chunk number 5: MiRaGE.Rnw:191-192
###################################################
result$P1[1:3,]


###################################################
### code chunk number 6: MiRaGE.Rnw:205-207
###################################################
require(humanStemCell)
data(fhesc)


###################################################
### code chunk number 7: MiRaGE.Rnw:211-214
###################################################
pData(fhesc)[["sample_name"]] <- c("neg.1","neg.2","neg.3",
"pos.1","pos.2","pos.3")
fData(fhesc)[["gene_id"]] <-rownames(exprs(fhesc))


###################################################
### code chunk number 8: MiRaGE.Rnw:217-219
###################################################
require(MiRaGE)
result <- MiRaGE(fhesc,location="web",species="HS",ID="affy_hg_u133a_2")


###################################################
### code chunk number 9: MiRaGE.Rnw:222-223
###################################################
result$P0[order(result$P0[,2])[1:5],]


###################################################
### code chunk number 10: MiRaGE.Rnw:231-234
###################################################
require(beadarrayExampleData)
data(exampleBLData)
data(exampleSummaryData)


###################################################
### code chunk number 11: MiRaGE.Rnw:246-251
###################################################
vv <- exampleSummaryData[,1:12]
 fData(vv)[["gene_id"]] <- fData(exampleSummaryData)[["IlluminaID"]]
 pData(vv)[["sample_name"]] <- c("neg.1","neg.2","neg.3","neg.4",
"neg.5","neg.6","brain.1","brain.2","brain.3","brain.4","brain.5","brain.6")
result <- MiRaGE(vv,species="HS",ID="illumina_humanwg_6_v3")


###################################################
### code chunk number 12: MiRaGE.Rnw:254-255
###################################################
result$P1[order(result$P1[,2])[1:5],]


###################################################
### code chunk number 13: MiRaGE.Rnw:283-284
###################################################
save(file="TBL2",TBL2)


###################################################
### code chunk number 14: MiRaGE.Rnw:287-288
###################################################
load("TBL2")


###################################################
### code chunk number 15: MiRaGE.Rnw:291-292 (eval = FALSE)
###################################################
## result <- MiRaGE(...,species_force=F)


###################################################
### code chunk number 16: MiRaGE.Rnw:301-305
###################################################
library(MiRaGE)
data(gene_exp)
library(Biobase)
result <- MiRaGE(gene_exp,species="HS")


###################################################
### code chunk number 17: UnevaluatedCode (eval = FALSE)
###################################################
## TBL2_HS_gen() 


###################################################
### code chunk number 18: UnevaluatedCode (eval = FALSE)
###################################################
## TBL2_MM_gen()


###################################################
### code chunk number 19: UnevaluatedCode (eval = FALSE)
###################################################
## id_conv_gen(SP="MM")


###################################################
### code chunk number 20: UnevaluatedCode (eval = FALSE)
###################################################
## id_conv_gen(SP="HS")


###################################################
### code chunk number 21: UnevaluatedCode (eval = FALSE)
###################################################
## HS_conv_id()


###################################################
### code chunk number 22: UnevaluatedCode (eval = FALSE)
###################################################
## MM_conv_id()


###################################################
### code chunk number 23: MiRaGE.Rnw:345-346
###################################################
p.adjust(result$P1[,2],method="BH")


###################################################
### code chunk number 24: MiRaGE.Rnw:350-351
###################################################
result$P1[,1][p.adjust(result$P1[,2],method="BH")<0.05]


