### R code from vignette source 'MulcomVignette.Rnw'

###################################################
### code chunk number 1: Library
###################################################
library(Mulcom)


###################################################
### code chunk number 2: LoadDataSet
###################################################
data("benchVign")


###################################################
### code chunk number 3: MulcomTest
###################################################
Affy$Groups


###################################################
### code chunk number 4: MulcomTest
###################################################
mulcomScore <- mulScores(Affy, Affy$Groups)


###################################################
### code chunk number 5: MulcomCalc
###################################################
sg <- mulCalc(mulcomScore, m = 0.3, t = 3)
sg


###################################################
### code chunk number 6: MulcomPermutation
###################################################
permutation <- mulPerm(Affy, Affy$Groups, np = 100, seed=7)
#permutationIlmn <- mulPerm(Ilmn, Ilmn$Groups, 5, 7)
#load("permutation.rda")
#load("permIlmn.rda")


###################################################
### code chunk number 7: FDR
###################################################
fsg <- mulFSG(permutation, m = 0.3, t = 3)
fsg

fdr <- fsg/sg
fdr


###################################################
### code chunk number 8: optimization
###################################################
optimization <- mulOpt(permutation, vm = seq(0,0.5, 0.1), vt = seq(1,3, 0.1))


###################################################
### code chunk number 9: ThresholdOptimization
###################################################
h1Opt <- mulParOpt(permutation, optimization, ind = 1, th = 0.05)


###################################################
### code chunk number 10: thOpt
###################################################
h1Opt


###################################################
### code chunk number 11: ThresholdOptimization
###################################################
h1Opt <- mulParOpt(permutation, optimization, ind = 1, th = 0.05)


###################################################
### code chunk number 12: MulComGenes
###################################################
## 1h
h1Opt <- mulParOpt(permutation, optimization, ind = 1, th = 0.05)
affyMulc1Probes <- mulDiff(Affy, permutation, m = h1Opt[2], t = h1Opt[1], ind = 1)


###################################################
### code chunk number 13: MulComGenes
###################################################
## 6h
h6Opt <- mulParOpt(permutation,optimization, ind = 2, th = 0.05)
affyMulc6Probes <- mulDiff(Affy, permutation, h6Opt[2], h6Opt[1], 2)


###################################################
### code chunk number 14: MulComGenes1
###################################################
## 24h
h24Opt <- mulParOpt(permutation,optimization, ind = 3, th = 0.1)
affyMulc24Probes <- mulDiff(Affy, permutation, h24Opt[2], h24Opt[1], 3)


###################################################
### code chunk number 15: MulComGenes2
###################################################
## B4
b4Opt <- mulParOpt(permutation,optimization, ind = 4, th = 0.05)
affyMulcB4Probes <- mulDiff(Affy, permutation, b4Opt[2], b4Opt[1], 4)


###################################################
### code chunk number 16: MulComGenes3
###################################################
mulcomGeneList <- unique(c(affyMulc1Probes, affyMulc6Probes, affyMulcB4Probes))


###################################################
### code chunk number 17: mulInt
###################################################
intersection <- mulInt(affyMulc1Probes,affyMulc6Probes)


###################################################
### code chunk number 18: permutation and optimization illumina
###################################################
#permutationIlmn <- mulPerm(Ilmn, Ilmn$Groups, np = 100, seed = 7)
#optimizationIlmn <- mulOpt(permutationIlmn, vm = seq(0.1,0.5, 0.1), vt = seq(1,3, 0.1))


###################################################
### code chunk number 19: IlmnMulcomGene
###################################################
# ,echo=F, results=hide
## 1h
#h1OptIlmn <- mulParOpt(permutationIlmn,optimizationIlmn,1,0.05)
#IlmnMulc1ProbesIlmn <- mulDiff(Ilmn, permutationIlmn, h1OptIlmn[2], h1OptIlmn[1], 1)
## 6h
#h6OptIlmn <- mulParOpt(permutationIlmn,optimizationIlmn,2,0.05)
#IlmnMulc6ProbesIlmn <- mulDiff(Ilmn, permutationIlmn, h6OptIlmn[2], h6OptIlmn[1], 2)
## 24h
#h24OptIlmn <- mulParOpt(permutationIlmn,optimizationIlmn,3,0.05)
#IlmnMulc24ProbesIlmn <- mulDiff(Ilmn, permutationIlmn, h24OptIlmn[2], h24OptIlmn[1], 2)
# B4
#b4OptIlmn <- mulParOpt(permutationIlmn,optimizationIlmn,4,0.05)
#IlmnMulcB4ProbesIlmn <- mulDiff(Ilmn, permutationIlmn, b4OptIlmn[2], b4OptIlmn[1], 4)
#Ilmnmulcom <- Ilmn[which(match(featureNames(Ilmn), unique(c(IlmnMulc24ProbesIlmn, IlmnMulc1ProbesIlmn, IlmnMulc6ProbesIlmn, IlmnMulcB4ProbesIlmn)), nomatch = 0)>0),]
#mulcomGeneListIlmn <- unique(c(IlmnMulc24ProbesIlmn, IlmnMulc1ProbesIlmn, IlmnMulc6ProbesIlmn, IlmnMulcB4ProbesIlmn))


###################################################
### code chunk number 20: Intersetction
###################################################
data("others")
mulAffy <- rep(0, length(AffyIlmn$Probe.x))
mulAffy[which(match(AffyIlmn$Probe.x, mulcomGeneList, nomatch=0)>0)] <-1
mulIlmn <- rep(0, length(AffyIlmn$Probe.x))
mulIlmn[which(match(AffyIlmn$Probe.y, mulcomGeneListIlmn, nomatch=0)>0)] <-1
mulConc <- mulAffy * mulIlmn
mulTot <- length(which(mulAffy + mulIlmn >0))
sum(mulConc)/mulTot


###################################################
### code chunk number 21: MulcomVignette.Rnw:341-352
###################################################
mulIlmnSymbols <- unique(AffyIlmn[which(match(AffyIlmn$Probe.y, mulcomGeneListIlmn, nomatch = 0)>0),]$Symbol)
mulAffySymbols <- unique(AffyIlmn[which(match(AffyIlmn$Probe.x, mulcomGeneList, nomatch = 0)>0),]$Symbol)

mulIntSym <- length(intersect(mulIlmnSymbols, mulAffySymbols))
mulTotSym <- length(unique(c(mulIlmnSymbols, mulAffySymbols)))

samIntSym <- length(intersect(samIlmnSymbols, samAffySymbols))
samTotSym <- length(unique(c(samIlmnSymbols, samAffySymbols)))

limIntSym <- length(intersect(limmaIlmnSymbols, limmaAffySymbols))
limTotSym <- length(unique(c(limmaIlmnSymbols, limmaAffySymbols)))


###################################################
### code chunk number 22: MulcomVignette.Rnw:354-357
###################################################
mulIntSym/mulTotSym
samIntSym/samTotSym
limIntSym/limTotSym


