### R code from vignette source 'ROCnotes.Rnw'

###################################################
### code chunk number 1: ROCnotes.Rnw:50-52
###################################################
library(ROC)
print(getClass("rocc"))


###################################################
### code chunk number 2: ROCnotes.Rnw:61-62
###################################################
print(rocdemo.sca)


###################################################
### code chunk number 3: ROCnotes.Rnw:71-72
###################################################
print(dxrule.sca)


###################################################
### code chunk number 4: ROCnotes.Rnw:77-81
###################################################
set.seed(123)
state <- c(0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1)
markers <- c(1,2,1,1,2,3,3,4,2,1,1,3,2,3,2,4,5,2,3,4)+runif(20,-1,1)
roc1 <- rocdemo.sca( truth=state, data=markers, rule=dxrule.sca )


###################################################
### code chunk number 5: ROCnotes.Rnw:87-88
###################################################
plot(roc1)


###################################################
### code chunk number 6: ROCnotes.Rnw:106-110
###################################################
auc <- AUC(roc1); print(auc)
paucp4 <- pAUC(roc1,.4); print(paucp4)
rocp3 <- ROC(roc1,.3); print(rocp3)



###################################################
### code chunk number 7: ROCnotes.Rnw:117-119
###################################################
print(trapezint)



###################################################
### code chunk number 8: ROCnotes.Rnw:135-154
###################################################
library(Biobase)
data(sample.ExpressionSet)
myauc <- function(x) {
 dx <- as.numeric(sex) - 1 # phenoData is installed
 AUC( rocdemo.sca( truth=dx, data=x, rule=dxrule.sca ) )
 }
mypauc1 <- function(x) {
 dx <- as.numeric(sex) - 1
 pAUC( rocdemo.sca( truth=dx, data=x, rule=dxrule.sca ), .1 )
 }

allAUC <- esApply( sample.ExpressionSet[1:50,], 1, myauc )

allpAUC1 <- esApply( sample.ExpressionSet[1:50,], 1, mypauc1 )

print(featureNames(sample.ExpressionSet[1:50,])[order(allAUC, decreasing = TRUE)[1]])

print(featureNames(sample.ExpressionSet[1:50,])[order(allpAUC1, decreasing = TRUE)[1]])



###################################################
### code chunk number 9: ROCnotes.Rnw:166-178
###################################################
nResamp <- 5
nTiss <- ncol(exprs(sample.ExpressionSet))
nGenes <- nrow(exprs(sample.ExpressionSet[1:50,]))
out <- matrix(NA,nr=nGenes, nc=nResamp)
set.seed(123)
for (i in 1:nResamp)
 {
 TissInds <- sample(1:nTiss, size=nTiss, replace=TRUE)
 out[,i] <- esApply( sample.ExpressionSet[1:50,TissInds], 1, myauc )
 }
rout <- apply(out,2,rank)



