### R code from vignette source 'RPA.Rnw'

###################################################
### code chunk number 1: rpa
###################################################
require(affy)
require(affydata)
data(Dilution)


###################################################
### code chunk number 2: rpa (eval = FALSE)
###################################################
## eset <- rpa(Dilution)


###################################################
### code chunk number 3: rpaonline (eval = FALSE)
###################################################
## eset <- rpa.online(cel.files, save.batches.dir = ".")


###################################################
### code chunk number 4: RPA.pointestimate
###################################################
require(RPA)
sets <- geneNames(Dilution)[1:2]
rpa.results <- RPA.pointestimate(Dilution, sets)


###################################################
### code chunk number 5: visu (eval = FALSE)
###################################################
## plot(rpa.results, set = "1000_at", plots = "all")
## #plot(rpa.results, set = set, plots = "data")
## #plot(rpa.results, set = set, plots = "toydata.comparison")


###################################################
### code chunk number 6: barplots
###################################################
dat <- plot(rpa.results, set = "1000_at", plots = "all")


###################################################
### code chunk number 7: noise
###################################################
# Load libraries
require(affy)
require(affydata)
require(RPA)

# Load example data
data(Dilution)

# Define the probesets to check
sets <- geneNames(Dilution)[1:2]

# Robust Probabilistic Averaging model
rpa.results <- RPA.pointestimate(Dilution, sets)

# Provide a table of probe affinity and variance parameters
probe.parameter.table <- probe.performance(rpa.results)


###################################################
### code chunk number 8: setpriors
###################################################
priors <- list(alpha = NULL, beta = NULL, d = NULL)
set <- "1000_at"
priors$alpha <- 2
priors$beta[[set]] <- rep(1, 16)
probe.index <- 5
priors$beta[[set]][[probe.index]] <- 3
rpa.results <- RPA.pointestimate(Dilution, sets, priors = priors)


###################################################
### code chunk number 9: iter (eval = FALSE)
###################################################
## res <- rpa.fit(S)


###################################################
### code chunk number 10: details
###################################################
sessionInfo()


