/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.analysis.directed;

import net.sf.picard.metrics.MetricBase;

public class HsMetrics
extends MetricBase {
    public String BAIT_SET;
    public long GENOME_SIZE;
    public long BAIT_TERRITORY;
    public long TARGET_TERRITORY;
    public double BAIT_DESIGN_EFFICIENCY;
    public long TOTAL_READS;
    public long PF_READS;
    public long PF_UNIQUE_READS;
    public double PCT_PF_READS;
    public double PCT_PF_UQ_READS;
    public long PF_UQ_READS_ALIGNED;
    public double PCT_PF_UQ_READS_ALIGNED;
    public long PF_UQ_BASES_ALIGNED;
    public long ON_BAIT_BASES;
    public long NEAR_BAIT_BASES;
    public long OFF_BAIT_BASES;
    public long ON_TARGET_BASES;
    public double PCT_SELECTED_BASES;
    public double PCT_OFF_BAIT;
    public double ON_BAIT_VS_SELECTED;
    public double MEAN_BAIT_COVERAGE;
    public double MEAN_TARGET_COVERAGE;
    public double PCT_USABLE_BASES_ON_BAIT;
    public double PCT_USABLE_BASES_ON_TARGET;
    public double FOLD_ENRICHMENT;
    public double ZERO_CVG_TARGETS_PCT;
    public double FOLD_80_BASE_PENALTY;
    public double PCT_TARGET_BASES_2X;
    public double PCT_TARGET_BASES_10X;
    public double PCT_TARGET_BASES_20X;
    public double PCT_TARGET_BASES_30X;
    public Long HS_LIBRARY_SIZE;
    public double HS_PENALTY_10X;
    public double HS_PENALTY_20X;
    public double HS_PENALTY_30X;

    public void calculateDerivedMetrics() {
        this.BAIT_DESIGN_EFFICIENCY = (double)this.TARGET_TERRITORY / (double)this.BAIT_TERRITORY;
        this.PCT_PF_READS = (double)this.PF_READS / (double)this.TOTAL_READS;
        this.PCT_PF_UQ_READS = (double)this.PF_UNIQUE_READS / (double)this.TOTAL_READS;
        this.PCT_PF_UQ_READS_ALIGNED = (double)this.PF_UQ_READS_ALIGNED / (double)this.PF_UNIQUE_READS;
        double denominator = this.ON_BAIT_BASES + this.NEAR_BAIT_BASES + this.OFF_BAIT_BASES;
        this.PCT_SELECTED_BASES = (double)(this.ON_BAIT_BASES + this.NEAR_BAIT_BASES) / denominator;
        this.PCT_OFF_BAIT = (double)this.OFF_BAIT_BASES / denominator;
        this.ON_BAIT_VS_SELECTED = (double)this.ON_BAIT_BASES / (double)(this.ON_BAIT_BASES + this.NEAR_BAIT_BASES);
        this.MEAN_BAIT_COVERAGE = (double)this.ON_BAIT_BASES / (double)this.BAIT_TERRITORY;
        this.FOLD_ENRICHMENT = (double)this.ON_BAIT_BASES / denominator / ((double)this.BAIT_TERRITORY / (double)this.GENOME_SIZE);
    }
}

