/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.sam.SamAlignmentMerger;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMProgramRecord;

public class MergeBamAlignment
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Merges alignment data from a SAM or BAM " + "file with additional data stored in an unmapped BAM file and produces a third SAM " + "or BAM file of aligned and unaligned reads.  NOTE that this program expects to " + "find a sequence dictionary in the same directory as REFERENCE_SEQUENCE and expects it " + "to have the same base name as the reference fasta except with the extension '.dict'";
    @Option(shortName="UNMAPPED", doc="Original SAM or BAM file of unmapped reads, which must be in queryname order.")
    public File UNMAPPED_BAM;
    @Option(shortName="ALIGNED", doc="SAM or BAM file with alignment data.")
    public File ALIGNED_BAM;
    @Option(shortName="O", doc="Merged SAM or BAM file to write to.")
    public File OUTPUT;
    @Option(shortName="R", doc="Path to the fasta file for the reference sequence.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="PG", doc="The program group ID of the aligner (if not supplied by the aligned file).", optional=true)
    public String PROGRAM_RECORD_ID;
    @Option(shortName="PG_VERSION", doc="The version of the program group (if not supplied by the aligned file).", optional=true)
    public String PROGRAM_GROUP_VERSION;
    @Option(shortName="PG_COMMAND", doc="The command line of the program group (if not supplied by the aligned file).", optional=true)
    public String PROGRAM_GROUP_COMMAND_LINE;
    @Option(shortName="PG_NAME", doc="The name of the program group (if not supplied by the aligned file).", optional=true)
    public String PROGRAM_GROUP_NAME;
    @Option(doc="Whether this is a paired-end run. ", shortName="PE")
    public Boolean PAIRED_RUN;
    @Option(doc="The expected jump size (required if this is a jumping library).", shortName="JUMP", optional=true)
    public Integer JUMP_SIZE;
    @Option(doc="Whether to clip adapters where identified.")
    public boolean CLIP_ADAPTERS = true;
    @Option(doc="Whether the lane is bisulfite sequence (used when caculating the NM tag).")
    public boolean IS_BISULFITE_SEQUENCE = false;
    @Option(doc="Whether to output only aligned reads.  ")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(doc="The maximum number of insertions or deletions permitted for an alignment to be included.  Alignments with more than this many insertions or deletions will be ignored.", shortName="MAX_GAPS")
    public int MAX_INSERTIONS_OR_DELETIONS = 1;
    @Option(doc="Reserved alignment attributes (tags starting with X, Y, or Z) that should be brought over from the alignment data when merging.")
    public List<String> ATTRIBUTES_TO_RETAIN = new ArrayList<String>();
    private static final Log log = Log.getInstance(MergeBamAlignment.class);

    public static void main(String[] argv) {
        System.exit(new MergeBamAlignment().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        SAMProgramRecord prod = null;
        if (this.PROGRAM_RECORD_ID != null) {
            prod = new SAMProgramRecord(this.PROGRAM_RECORD_ID);
            prod.setProgramVersion(this.PROGRAM_GROUP_VERSION);
            prod.setCommandLine(this.PROGRAM_GROUP_COMMAND_LINE);
            prod.setProgramName(this.PROGRAM_GROUP_NAME);
        }
        SamAlignmentMerger merger = new SamAlignmentMerger(this.UNMAPPED_BAM, this.OUTPUT, this.REFERENCE_SEQUENCE, prod, this.CLIP_ADAPTERS, this.IS_BISULFITE_SEQUENCE, this.PAIRED_RUN, this.JUMP_SIZE != null, this.ALIGNED_READS_ONLY, this.ALIGNED_BAM, this.MAX_INSERTIONS_OR_DELETIONS, this.ATTRIBUTES_TO_RETAIN);
        merger.mergeAlignment();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (!(this.PROGRAM_RECORD_ID == null && this.PROGRAM_GROUP_VERSION == null && this.PROGRAM_GROUP_COMMAND_LINE == null || this.PROGRAM_RECORD_ID != null && this.PROGRAM_GROUP_VERSION != null && this.PROGRAM_GROUP_COMMAND_LINE != null)) {
            return new String[]{"PROGRAM_RECORD_ID, PROGRAM_GROUP_VERSION, and PROGRAM_GROUP_COMMAND_LINE must all be supplied or none should be included."};
        }
        return null;
    }
}

