/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.picard.sam.SamFileValidator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMValidationError;

public class ValidateSamFile
extends CommandLineProgram {
    @Usage
    public final String usage = this.getStandardUsagePreamble() + "Read a SAM or BAM file and report on its validity.";
    @Option(shortName="I", doc="Input SAM/BAM file")
    public File INPUT;
    @Option(shortName="O", doc="Output file or standard out if missing", optional=true)
    public File OUTPUT;
    @Option(shortName="M", doc="Mode of output")
    public Mode MODE = Mode.VERBOSE;
    @Option(doc="List of validation error types to ignore.")
    public List<SAMValidationError.Type> IGNORE = new ArrayList<SAMValidationError.Type>();
    @Option(shortName="MO", doc="The maximum number of lines output in verbose mode")
    public Integer MAX_OUTPUT = 100;
    @Option(shortName="R", doc="Reference sequence file, the NM tag check will be skipped if this is missing", optional=true)
    public File REFERENCE_SEQUENCE;
    @Option(doc="If true, only report errors, and ignore warnings.")
    public boolean IGNORE_WARNINGS = false;
    @Option(shortName="BISULFITE", doc="Whether the SAM or BAM file consists of bisulfite sequenced reads. If so, C->T is not counted as an error in computing the value of the NM tag.")
    public boolean IS_BISULFITE_SEQUENCED = false;

    public static void main(String[] args) {
        System.exit(new ValidateSamFile().instanceMain(args));
    }

    @Override
    protected int doWork() {
        PrintWriter out;
        IoUtil.assertFileIsReadable(this.INPUT);
        ReferenceSequenceFile reference = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IoUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
            reference = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
        }
        if (this.OUTPUT != null) {
            IoUtil.assertFileIsWritable(this.OUTPUT);
            try {
                out = new PrintWriter(this.OUTPUT);
            }
            catch (FileNotFoundException e) {
                throw new PicardException("Unexpected exception", e);
            }
        } else {
            out = new PrintWriter(System.out);
        }
        SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        SAMFileReader samReader = new SAMFileReader(this.INPUT);
        samReader.enableCrcChecking(true);
        SamFileValidator validator = new SamFileValidator(out);
        validator.setErrorsToIgnore(this.IGNORE);
        if (this.IGNORE_WARNINGS) {
            validator.setIgnoreWarnings(this.IGNORE_WARNINGS);
        }
        if (this.MODE == Mode.SUMMARY) {
            validator.setVerbose(false, 0);
        } else {
            validator.setVerbose(true, this.MAX_OUTPUT);
        }
        if (this.IS_BISULFITE_SEQUENCED) {
            validator.setBisulfiteSequenced(this.IS_BISULFITE_SEQUENCED);
        }
        validator.validateBamFileTermination(this.INPUT);
        boolean result = false;
        switch (this.MODE) {
            case SUMMARY: {
                result = validator.validateSamFileSummary(samReader, reference);
                break;
            }
            case VERBOSE: {
                result = validator.validateSamFileVerbose(samReader, reference);
            }
        }
        return result ? 0 : 1;
    }

    public static enum Mode {
        VERBOSE,
        SUMMARY;

    }
}

