/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.picard.PicardException;
import net.sf.picard.util.ResourceLimitedMap;
import net.sf.picard.util.ResourceLimitedMapFunctor;

public class FileAppendStreamLRUCache
extends ResourceLimitedMap<File, FileOutputStream> {
    public FileAppendStreamLRUCache(int cacheSize) {
        super(cacheSize, new Functor());
    }

    private static class Functor
    implements ResourceLimitedMapFunctor<File, FileOutputStream> {
        private static final int GC_FREQUENCY = 10000;
        private int numCloses = 0;

        private Functor() {
        }

        @Override
        public FileOutputStream makeValue(File file) {
            try {
                return new FileOutputStream(file, true);
            }
            catch (FileNotFoundException e) {
                throw new PicardException(file + "not found", e);
            }
        }

        @Override
        public void finalizeValue(File file, FileOutputStream fileOutputStream) {
            try {
                fileOutputStream.close();
                if (++this.numCloses % 10000 == 0) {
                    System.gc();
                    System.runFinalization();
                    this.numCloses = 0;
                }
            }
            catch (IOException e) {
                throw new PicardException("Exception closing FileOutputStream for " + file, e);
            }
        }
    }
}

