/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import net.sf.picard.PicardException;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.SolexaQualityConverter;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;

public class IlluminaUtil {
    public static String makeReadName(String runBarcode, int lane, int tile, int xCoordinate, int yCoordinate) {
        return runBarcode + ":" + lane + ":" + tile + ":" + xCoordinate + ":" + yCoordinate;
    }

    public static Integer getTileFromReadName(String readName) {
        int third;
        int second;
        int first = readName.indexOf(58);
        if (first > 0 && (second = readName.indexOf(58, first + 1)) > 0 && (third = readName.indexOf(58, second + 1)) > 0) {
            return Integer.parseInt(readName.substring(second + 1, third));
        }
        return null;
    }

    public static byte[] makePhredBinaryFromSolexaQualityAscii_1_3(String solexaQualities) {
        return IlluminaUtil.makePhredBinaryFromSolexaQualityAscii_1_3(solexaQualities, 0, solexaQualities.length());
    }

    public static byte[] makePhredBinaryFromSolexaQualityAscii_1_3(String solexaQualities, int offset, int length) {
        byte[] quals = StringUtil.stringToBytes(solexaQualities, offset, length);
        SolexaQualityConverter.getSingleton().convertSolexa_1_3_QualityCharsToPhredBinary(quals);
        return quals;
    }

    public static void convertSolexaQualityAscii_1_1_ToPhredBinary(byte[] solexaQualities) {
        SolexaQualityConverter.getSingleton().convertSolexaQualityCharsToPhredBinary(solexaQualities);
    }

    public static byte getSolexaQualityCharFromFourQualities(String[] qualities, int cycleNumber, FormatUtil formatter) {
        int startOffset;
        int bestQuality = Integer.MIN_VALUE;
        for (int i = startOffset = (cycleNumber - 1) * 4; i < startOffset + 4; ++i) {
            int quality = formatter.parseInt(qualities[i]);
            if (quality <= bestQuality) continue;
            bestQuality = quality;
        }
        int qualityAsCharacter = bestQuality + 64;
        if (qualityAsCharacter > 255) {
            throw new PicardException("Quality too large: " + bestQuality);
        }
        return (byte)(qualityAsCharacter & 0xFF);
    }

    public static enum AdapterPair {
        PAIRED_END("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCGGTTCAGCAGGAATGCCGAGACCGATCTCGTATGCCGTCTTCTGCTTG"),
        INDEXED("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCACACGTCTGAACTCCAGTCACNNNNNNNNATCTCGTATGCCGTCTTCTGCTTG"),
        SINGLE_END("AATGATACGGCGACCACCGAGATCTACACTCTTTCCCTACACGACGCTCTTCCGATCT", "AGATCGGAAGAGCTCGTATGCCGTCTTCTGCTTG"),
        ALTERNATIVE_SINGLE_END("AATGATACGGCGACCACCGACAGGTTCAGAGTTCTACAGTCCGACGATC", "TCGTATGCCGTCTTCTGCTTG");

        final String fivePrime;
        final String threePrime;
        final String fivePrimeReadOrder;
        final byte[] fivePrimeBytes;
        final byte[] threePrimeBytes;
        final byte[] fivePrimeReadOrderBytes;

        private AdapterPair(String fivePrime, String threePrime) {
            this.threePrime = threePrime;
            this.fivePrime = fivePrime;
            this.fivePrimeReadOrder = SequenceUtil.reverseComplement(fivePrime);
            this.threePrimeBytes = StringUtil.stringToBytes(threePrime);
            this.fivePrimeBytes = StringUtil.stringToBytes(fivePrime);
            this.fivePrimeReadOrderBytes = StringUtil.stringToBytes(this.fivePrimeReadOrder);
        }

        public String get3PrimeAdapter() {
            return this.threePrime;
        }

        public String get5PrimeAdapter() {
            return this.fivePrime;
        }

        public String get3PrimeAdapterInReadOrder() {
            return this.threePrime;
        }

        public String get5PrimeAdapterInReadOrder() {
            return this.fivePrimeReadOrder;
        }

        public byte[] get3PrimeAdapterBytes() {
            return this.threePrimeBytes;
        }

        public byte[] get5PrimeAdapterBytes() {
            return this.fivePrimeBytes;
        }

        public byte[] get3PrimeAdapterBytesInReadOrder() {
            return this.threePrimeBytes;
        }

        public byte[] get5PrimeAdapterBytesInReadOrder() {
            return this.fivePrimeReadOrderBytes;
        }
    }
}

