/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.ReadEnds;
import net.sf.picard.sam.ReadEndsCodec;
import net.sf.picard.sam.ReadEndsMap;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.IOUtil;

class DiskReadEndsMap
implements ReadEndsMap {
    private final File workDir = IoUtil.createTempDir("DREM.", null);
    private int sequenceIndexOfMapInRam = -1;
    private Map<String, ReadEnds> mapInRam = null;
    private final List<FileOutputStream> mapsOnDisk = new ArrayList<FileOutputStream>();
    private final List<Integer> sizeOfMapOnDisk = new ArrayList<Integer>();
    private final ElementCodec elementCodec = new ElementCodec();

    DiskReadEndsMap() {
        this.workDir.deleteOnExit();
    }

    @Override
    public ReadEnds remove(int mateSequenceIndex, String key) {
        this.ensureSequenceLoaded(mateSequenceIndex);
        return this.mapInRam.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSequenceLoaded(int mateSequenceIndex) {
        block10: {
            try {
                if (this.sequenceIndexOfMapInRam == mateSequenceIndex) {
                    return;
                }
                if (this.mapInRam != null) {
                    if (this.mapsOnDisk.size() > this.sequenceIndexOfMapInRam && this.mapsOnDisk.get(this.sequenceIndexOfMapInRam) != null) {
                        throw new IllegalStateException("Internal error");
                    }
                    OutputStream os = this.getOutputStreamForSequence(this.sequenceIndexOfMapInRam);
                    this.elementCodec.setOutputStream(os);
                    for (Map.Entry<String, ReadEnds> entry : this.mapInRam.entrySet()) {
                        this.elementCodec.encode(entry.getKey(), entry.getValue());
                    }
                    this.sizeOfMapOnDisk.set(this.sequenceIndexOfMapInRam, this.mapInRam.size());
                    this.mapsOnDisk.set(this.sequenceIndexOfMapInRam, null);
                    this.mapInRam.clear();
                } else {
                    this.mapInRam = new HashMap<String, ReadEnds>();
                }
                this.sequenceIndexOfMapInRam = mateSequenceIndex;
                if (this.mapsOnDisk.size() <= mateSequenceIndex || this.mapsOnDisk.get(mateSequenceIndex) == null) break block10;
                this.mapsOnDisk.get(mateSequenceIndex).close();
                this.mapsOnDisk.set(mateSequenceIndex, null);
                int numRecords = this.sizeOfMapOnDisk.get(mateSequenceIndex);
                this.sizeOfMapOnDisk.set(mateSequenceIndex, 0);
                File file = this.makeFileForSequence(mateSequenceIndex);
                FileInputStream is = null;
                try {
                    is = new FileInputStream(file);
                    this.elementCodec.setInputStream(is);
                    for (int i = 0; i < numRecords; ++i) {
                        MapEntry entry = this.elementCodec.decode();
                        this.mapInRam.put(entry.key, entry.readEnds);
                    }
                }
                catch (Throwable throwable) {
                    CloserUtil.close(is);
                    throw throwable;
                }
                CloserUtil.close(is);
                IOUtil.deleteFiles(file);
            }
            catch (IOException e) {
                throw new PicardException("Error loading new map from disk.", e);
            }
        }
    }

    @Override
    public void put(int mateSequenceIndex, String key, ReadEnds readEnds) {
        if (mateSequenceIndex == this.sequenceIndexOfMapInRam) {
            this.mapInRam.put(key, readEnds);
        } else {
            OutputStream os = this.getOutputStreamForSequence(mateSequenceIndex);
            this.elementCodec.setOutputStream(os);
            this.elementCodec.encode(key, readEnds);
            this.sizeOfMapOnDisk.set(mateSequenceIndex, this.sizeOfMapOnDisk.get(mateSequenceIndex) + 1);
        }
    }

    private File makeFileForSequence(int index) {
        File file = new File(this.workDir, index + ".read_ends");
        file.deleteOnExit();
        return file;
    }

    private OutputStream getOutputStreamForSequence(int mateSequenceIndex) {
        try {
            while (mateSequenceIndex >= this.mapsOnDisk.size()) {
                this.mapsOnDisk.add(null);
                this.sizeOfMapOnDisk.add(0);
            }
            FileOutputStream ret = this.mapsOnDisk.get(mateSequenceIndex);
            if (ret == null) {
                ret = new FileOutputStream(this.makeFileForSequence(mateSequenceIndex));
                this.mapsOnDisk.set(mateSequenceIndex, ret);
            }
            return ret;
        }
        catch (FileNotFoundException e) {
            throw new PicardException("Error creating temporary ReadEnds file", e);
        }
    }

    @Override
    public int size() {
        int total = this.sizeInRam();
        for (Integer mapSize : this.sizeOfMapOnDisk) {
            if (mapSize == null) continue;
            total += mapSize.intValue();
        }
        return total;
    }

    @Override
    public int sizeInRam() {
        return this.mapInRam != null ? this.mapInRam.size() : 0;
    }

    private static class ElementCodec {
        private final ReadEndsCodec readEndsCodec = new ReadEndsCodec();

        private ElementCodec() {
        }

        public void setInputStream(InputStream is) {
            this.readEndsCodec.setInputStream(is);
        }

        public void setOutputStream(OutputStream os) {
            this.readEndsCodec.setOutputStream(os);
        }

        public MapEntry decode() {
            try {
                MapEntry ret = new MapEntry();
                ret.setKey(this.readEndsCodec.getInputStream().readUTF());
                ret.setReadEnds(this.readEndsCodec.decode());
                return ret;
            }
            catch (IOException e) {
                throw new PicardException("Error loading ReadEndsMap from disk", e);
            }
        }

        public void encode(String key, ReadEnds readEnds) {
            try {
                this.readEndsCodec.getOutputStream().writeUTF(key);
                this.readEndsCodec.encode(readEnds);
            }
            catch (IOException e) {
                throw new PicardException("Error spilling ReadEndsMap to disk.", e);
            }
        }
    }

    private static class MapEntry {
        private String key;
        private ReadEnds readEnds;

        private MapEntry() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public ReadEnds getReadEnds() {
            return this.readEnds;
        }

        public void setReadEnds(ReadEnds readEnds) {
            this.readEnds = readEnds;
        }
    }
}

