/*
 * Decompiled with CFR 0.152.
 */
package reder.io;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.sourceforge.jlibeps.epsgraphics.EpsGraphics2D;
import reder.application.GraphTask;
import reder.application.MainFrame;

public class ExportImage {
    private JPanel exportpanel = null;
    private static double scale;
    private String ioFileType;
    private String saveAddress;
    private String taskProgress;

    public ExportImage() {
        scale = 1.0;
        this.taskProgress = "running";
    }

    public String getProgress() {
        return this.taskProgress;
    }

    public void inputAndGo(GraphTask drawpanel, double scaleIn, String saveAddress, String ioFileType) {
        this.exportpanel = drawpanel;
        scale = scaleIn;
        this.ioFileType = ioFileType;
        this.saveAddress = saveAddress;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals(this.ioFileType)) {
            this.saveAddress = saveAddress + "." + ioFileType;
        }
        try {
            if (this.ioFileType.equals("pdf")) {
                this.printPDF();
            } else {
                this.printImage();
            }
            this.taskProgress = "endload";
        }
        catch (IOException ex) {
            this.taskProgress = "halt";
        }
        catch (DocumentException ex) {
            this.taskProgress = "halt";
        }
    }

    public void inputAndGo(JPanel plotpanel, double scaleIn, String saveAddress, String ioFileType) {
        this.exportpanel = plotpanel;
        scale = scaleIn;
        this.ioFileType = ioFileType;
        this.saveAddress = saveAddress;
        String[] address = saveAddress.split("\\.");
        String end = address[address.length - 1];
        if (!end.equals(this.ioFileType)) {
            this.saveAddress = saveAddress + "." + ioFileType;
        }
        try {
            if (this.ioFileType.equals("eps")) {
                this.printEPS();
            } else {
                this.printImage();
            }
            this.taskProgress = "endload";
        }
        catch (IOException ex) {
            this.taskProgress = "halt";
        }
        catch (DocumentException ex) {
            this.taskProgress = "halt";
        }
    }

    public void printImage() throws IOException, DocumentException {
        int scaleW = (int)((double)this.exportpanel.getWidth() * scale);
        int scaleH = (int)((double)this.exportpanel.getHeight() * scale);
        BufferedImage image = new BufferedImage(scaleW, scaleH, 4);
        Graphics2D g = image.createGraphics();
        g.scale(scale, scale);
        this.exportpanel.printAll(g);
        this.exportpanel.printComponents(g);
        g.dispose();
        if (this.ioFileType.equals("bmp")) {
            ImageIO.write((RenderedImage)image, "BMP", new File(this.saveAddress));
        } else if (this.ioFileType.equals("jpg")) {
            ImageIO.write((RenderedImage)image, "JPEG", new File(this.saveAddress));
        } else if (this.ioFileType.equals("png")) {
            ImageIO.write((RenderedImage)image, "PNG", new File(this.saveAddress));
        } else if (this.ioFileType.equals("gif")) {
            ImageIO.write((RenderedImage)image, "GIF", new File(this.saveAddress));
        }
    }

    public void printPDF() throws IOException, DocumentException {
        double zoom = 1.0 / MainFrame.getZoom();
        double resolution = Math.max(1.0, zoom);
        int scaleW = (int)((double)this.exportpanel.getWidth() * resolution);
        int scaleH = (int)((double)this.exportpanel.getHeight() * resolution);
        Document doc = new Document(new Rectangle(scaleW, scaleH));
        PdfWriter writer = PdfWriter.getInstance(doc, new FileOutputStream(this.saveAddress));
        doc.open();
        PdfContentByte cb = writer.getDirectContent();
        Graphics2D g2 = cb.createGraphics(scaleW, scaleH);
        double cx = scaleW / 2;
        double cy = scaleH / 2;
        AffineTransform tr1 = g2.getTransform();
        AffineTransform tr2 = new AffineTransform(tr1);
        tr2.translate(-cx, -cy);
        tr2.scale(resolution, resolution);
        tr2.translate(cx / resolution, cy / resolution);
        g2.setTransform(tr2);
        this.exportpanel.paint(g2);
        g2.setTransform(tr1);
        g2.dispose();
        doc.close();
    }

    public void printEPS() throws IOException {
        FileOutputStream epsWriter = new FileOutputStream(this.saveAddress);
        EpsGraphics2D g1 = new EpsGraphics2D(null, epsWriter, 0, 0, this.exportpanel.getWidth(), this.exportpanel.getHeight());
        this.exportpanel.paintAll(g1);
        g1.flush();
        g1.close();
        epsWriter.close();
    }
}

