/*
 * Decompiled with CFR 0.152.
 */
package reder.plugins;

import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenu;
import reder.plugins.PluginAddons;
import reder.plugins.PluginMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugins {
    private final String pluginName;
    private final JMenu pluginMenu;
    private ArrayList<PluginMethods> methodsList;
    private ArrayList<PluginAddons> addonsList;
    private boolean setToDelete;
    private boolean isSelected;

    public Plugins(String pluginName) {
        this.pluginName = pluginName;
        this.pluginMenu = new JMenu();
        this.methodsList = new ArrayList();
        this.addonsList = new ArrayList();
        this.setToDelete = false;
        this.isSelected = true;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setToDelete() {
        this.setToDelete = true;
    }

    public boolean isToDelete() {
        return this.setToDelete;
    }

    public JMenu getPluginMenu() {
        return this.pluginMenu;
    }

    public void addMethod(String name, String code) {
        boolean flag = false;
        for (int i = 0; i < this.methodsList.size(); ++i) {
            PluginMethods m = this.methodsList.get(i);
            if (!m.getMethodName().equals(name)) continue;
            m.setMethodCode(code);
            flag = true;
            break;
        }
        if (!flag) {
            this.methodsList.add(new PluginMethods(name, code));
        }
    }

    public void addAddon(String name, String code) {
        boolean flag = false;
        for (int i = 0; i < this.addonsList.size(); ++i) {
            PluginAddons a = this.addonsList.get(i);
            if (!a.getAddonName().equals(name)) continue;
            a.setAddonCode(code);
            flag = true;
            break;
        }
        if (!flag) {
            this.addonsList.add(new PluginAddons(name, code));
        }
    }

    public ArrayList<PluginMethods> getMethods() {
        return this.methodsList;
    }

    public String[] getMethodsName() {
        String[] names = new String[this.methodsList.size()];
        for (int i = 0; i < this.methodsList.size(); ++i) {
            names[i] = this.methodsList.get(i).getMethodName();
        }
        return names;
    }

    public ArrayList<PluginAddons> getAddons() {
        return this.addonsList;
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public int addMethodsFromR(Vector<String> code) {
        int cont = 0;
        for (int i = 0; i < code.size(); ++i) {
            int addCount = this.parseMethodsFromR(code.get(i));
            cont += addCount;
        }
        return cont;
    }

    public int addAddonsFromR(Vector<String> code) {
        int cont = 0;
        for (int i = 0; i < code.size(); ++i) {
            int addCount = this.parseAddonsFrom(code.get(i));
            cont += addCount;
        }
        return cont;
    }

    private int parseMethodsFromR(String code) {
        Pattern functionPattern = Pattern.compile("(<[^\\s]+>).*");
        Matcher matcher = functionPattern.matcher(code);
        if (matcher.find()) {
            String name = matcher.group(1);
            code = code.replaceAll(name, "");
            name = name.replaceAll("\\s*", "");
            name = name.replaceAll("<", "");
            name = name.replaceAll(">", "");
            this.addMethod(name, "\n" + code + "\n\n");
            return 1;
        }
        return 0;
    }

    private int parseAddonsFrom(String code) {
        Pattern functionPattern = Pattern.compile("([^\\s]+)[\\s]*(<-)[\\s]*(function)[\\s]*(\\()");
        Matcher matcher = functionPattern.matcher(code);
        if (matcher.find()) {
            String name = matcher.group(1).replaceAll("\\s", "");
            this.addAddon(name, "\n\n" + code + "\n\n");
            return 1;
        }
        return 0;
    }
}

