### R code from vignette source 'rnaseqAnalysis.Rnw'

###################################################
### code chunk number 1: load data (eval = FALSE)
###################################################
## library(ReportingTools)
## data(mockRnaSeqData)


###################################################
### code chunk number 2: run_edgeR (eval = FALSE)
###################################################
## library(edgeR)
## conditions <- c(rep("case",3), rep("control", 3))
## d <- DGEList(counts = mockRnaSeqData, group = conditions)
## d <- calcNormFactors(d)
## d <- estimateCommonDisp(d)
## ## Get an edgeR object
## edgeR.de <- exactTest(d)


###################################################
### code chunk number 3: edgeR_report (eval = FALSE)
###################################################
## library(lattice)
## rep.theme <- reporting.theme()
## ## Change symbol colors in plots
## rep.theme$superpose.symbol$col <- c("blue", "red")
## rep.theme$superpose.symbol$fill <- c("blue", "red")
## lattice.options(default.theme = rep.theme)
## 
## deReport <- HTMLReport(shortName = 'RNAseq_analysis_with_edgeR',
##     title = 'RNA-seq analysis of differential expression using edgeR',
##     reportDirectory = "./reports/",
##     baseUrl = "")
## ## Publish a report of the top 10 genes with p-values < 0.05 and log-fold change > 2
## publish(edgeR.de, deReport, mockRnaSeqData, 
## 	conditions, annotation.db = 'org.Mm.eg', 
## 	pvalueCutoff = .05, lfc = 2, n = 10)
## finish(deReport)


###################################################
### code chunk number 4: Do GO analysis (eval = FALSE)
###################################################
## library(GOstats)
## library(org.Mm.eg.db)
## tt<-topTags(edgeR.de, n = 1000, adjust.method = 'BH', sort.by = 'p.value')
## selectedIDs<-rownames(tt$table)
## universeIDs<-rownames(mockRnaSeqData)
## goParams <- new("GOHyperGParams", 
##     geneIds = selectedIDs, 
##     universeGeneIds = universeIDs, 
##     annotation ="org.Mm.eg" , 
##     ontology = "MF", 
##     pvalueCutoff = 0.01,
##     conditional = TRUE, 
##     testDirection = "over")
## goResults <- hyperGTest(goParams)


###################################################
### code chunk number 5: make the GO report (eval = FALSE)
###################################################
## goReport <- HTMLReport(shortName = 'go_analysis_rnaseq',
## 	title = "GO analysis of mockRnaSeqData",
## 	reportDirectory = "./reports",
## 	baseUrl = "")
## publish(goResults, goReport, selectedIDs, annotation.db="org.Mm.eg", 
## 	pvalueCutoff= 0.05, makePlot=TRUE)
## finish(goReport)


###################################################
### code chunk number 6: Do PFAM analysis (eval = FALSE)
###################################################
## library(Category)
## params <- new("PFAMHyperGParams", 
## 	geneIds= selectedIDs, 
## 	universeGeneIds=universeIDs, 
## 	annotation="org.Mm.eg",
## 	pvalueCutoff= 0.01,
## 	testDirection="over")
## PFAMResults <- hyperGTest(params)


###################################################
### code chunk number 7: make the PFAM report (eval = FALSE)
###################################################
## PFAMReport <- HTMLReport(shortName = 'pfam_analysis_rnaseq',
## 	title = "PFAM analysis of mockRnaSeqData",
## 	reportDirectory = "./reports",
## 	baseUrl = "")
## publish(PFAMResults, PFAMReport, selectedIDs, annotation.db="org.Mm.eg",categorySize=5)
## finish(PFAMReport)


###################################################
### code chunk number 8: make the index page (eval = FALSE)
###################################################
## indexPage <- HTMLReport(shortName = "indexRNASeq",
##     title = "Analysis of mockRnaSeqData",
##     reportDirectory = "./reports",
##     baseUrl = "")
## publish(c(deReport,goReport, PFAMReport), indexPage)
## finish(indexPage)


