### R code from vignette source 'beadlevel.rnw'

###################################################
### code chunk number 1: prelim
###################################################
library(beadarrayExampleData)
library(beadarray)
data(exampleBLData)



###################################################
### code chunk number 2: options
###################################################
options(width = 80)


###################################################
### code chunk number 3: readIllumina (eval = FALSE)
###################################################
## BLData = readIllumina(useImages=FALSE, illuminaAnnotation = "Humanv3")


###################################################
### code chunk number 4: annotation
###################################################

suggestAnnotation(exampleBLData,verbose=TRUE)
annotation(exampleBLData) <-"Humanv3"



###################################################
### code chunk number 5: BLData
###################################################

class(exampleBLData)
slotNames(exampleBLData)

##Get the beadData for array-section 1
exampleBLData[[1]][1:10,]

##Alternative using accessor function
getBeadData(exampleBLData, array=1, what="Grn")[1:10]

##Get unique ProbeIDs. These are the ArrayAddressIDs
uIDs = unique(getBeadData(exampleBLData, array=1, what="ProbeID"))
uIDs[1:10]


###################################################
### code chunk number 6: metrics
###################################################

metrics(exampleBLData)

p95(exampleBLData, "Grn")

snr(exampleBLData, "Grn")




###################################################
### code chunk number 7: transform
###################################################

log2(exampleBLData[[1]][1:10,2])

logGreenChannelTransform

logGreenChannelTransform(exampleBLData, array=1)[1:10]

logRedChannelTransform



###################################################
### code chunk number 8: BeadLevelBoxplots
###################################################
boxplot(exampleBLData, las=2, outline=FALSE, ylim=c(4,12))


###################################################
### code chunk number 9: Imageplot1
###################################################


imageplot(exampleBLData, array=1, low="lightgreen", high="darkgreen")



###################################################
### code chunk number 10: Imageplot2
###################################################

imageplot(exampleBLData, array=2, low="lightgreen", high="darkgreen")



###################################################
### code chunk number 11: BASH (eval = FALSE)
###################################################
## 
## 
## bsh = BASH(exampleBLData, array=1:2)
## 


###################################################
### code chunk number 12: savingBASH (eval = FALSE)
###################################################
## 
## for(i in 1:2){
## 
## 	BLData <- setWeights(exampleBLData, wts=bsh$wts[[i]], array=i)
## 
## }
## 
## BLData <- insertSectionData(exampleBLData, what="BASHQC", data = bsh$QC)
## 


###################################################
### code chunk number 13: getBASH
###################################################

table(getBeadData(exampleBLData, array=1, what="wts"))
table(getBeadData(exampleBLData, array=2, what="wts"))




###################################################
### code chunk number 14: masks
###################################################

showArrayMask(exampleBLData, array=2)



###################################################
### code chunk number 15: controlPlot
###################################################

p <- combinedControlPlot(exampleBLData)



###################################################
### code chunk number 16: doPlot
###################################################

if(!is.null(p)){ 
p 
} else plot(1:10,type="n",axes=F, )





###################################################
### code chunk number 17: qaSummary
###################################################

quickSummary(exampleBLData, array=1)


qcReport <- makeQCTable(exampleBLData)

head(qcReport)[,1:5]

BLData <- insertSectionData(exampleBLData, what="BeadLevelQC", data=qcReport)

for(i in 1:2){
print(controlProbeDetection(exampleBLData, array = i, negativeTag = "negative"))
}




###################################################
### code chunk number 18: qcPipeline (eval = FALSE)
###################################################
## 
## expressionQCPipeline(exampleBLData, qcDir="QC")
## 
## 


###################################################
### code chunk number 19: createBeadSummaryData
###################################################

BSData <- summarize(exampleBLData)



###################################################
### code chunk number 20: createBeadSummaryData (eval = FALSE)
###################################################
## 
## myMedian <- function(x) median(x, na.rm=TRUE)
## myMad <- function(x) mad(x, na.rm=TRUE)
## 
## greenChannel2 <- new("illuminaChannel", greenChannelTransform, illuminaOutlierMethod, myMedian, myMad,"G")
## 
## BSData2 <- summarize(exampleBLData, list(greenChannel2))
## 


###################################################
### code chunk number 21: showBSData
###################################################
BSData



###################################################
### code chunk number 22: calculateDetection
###################################################


det = calculateDetection(BSData)

head(det)

Detection(BSData) <- det




###################################################
### code chunk number 23: sessionInfo
###################################################
sessionInfo()


