### R code from vignette source 'cnvGSA-vignette.Rnw'

###################################################
### code chunk number 1: workflow.outline.1
###################################################
library("cnvGSA")

slotNames("CnvGSAInput")


###################################################
### code chunk number 2: workflow.outline.2
###################################################
library("cnvGSAdata")
data("cnvGSA_input_example")
ls()
class(input)
slotNames(input)


###################################################
### code chunk number 3: workflow.outline.3
###################################################
data("cnvGSA_output_example")
ls()
class(output)
slotNames(output)


###################################################
### code chunk number 4: CNV.data.1
###################################################
str( cnvData(input), strict.width="cut" )


###################################################
### code chunk number 5: Loading.cnvData.from.files.1
###################################################
cnvData_demo <- list()
cnvFile <- system.file( "extdata", "cnv.gvf", package="cnvGSAdata" )
cnvData_demo$cnv <- readGVF( cnvFile )
rm(cnvFile)
head(cnvData_demo$cnv)


###################################################
### code chunk number 6: Loading.cnvData.from.files.2 (eval = FALSE)
###################################################
## genemapFile <- system.file(
##     "extdata",
##     "merge_00k_flank_hg18_refGene_jun_2011_exon.gff",
##     package = "cnvGSAdata"
## )
## fields <- read.table (
##     genemapFile,
##     sep = "\t",
##     comment.char = "",
##     quote = "\"",
##     header = FALSE,
##     stringsAsFactors = FALSE
## )
## genemap <- data.frame(
##     Chr = fields[,1],
##     Coord_i = fields[,4],
##     Coord_f = fields[,5],
##     GeneID = fields[,11],
##     stringsAsFactors = FALSE
## )
## genemap$Chr <- sub( genemap$Chr, pattern = "chr", replacement = "" )
## 
## cnvData_demo$gsep <- ";"
## cnvData_demo$cnv$Genes <- getCnvGenes( cnv=cnvData$cnv, genemap=genemap,
##     delim=cnvData_demo$gsep )
## rm( genemapFile, fields, genemap )


###################################################
### code chunk number 7: Loading.cnvData.from.files.3 (eval = FALSE)
###################################################
## s2classFile <- system.file( "extdata", "s2class.txt", package="cnvGSAdata" )
## cnvData_demo$s2class <- read.table(
##     s2classFile,
##     sep = "\t",
##     col.names = c("SampleID", "Class"),
##     stringsAsFactors = FALSE
## )
## rm(s2classFile)


###################################################
### code chunk number 8: Loading.gene.sets.1
###################################################
str( gsData(input), list.len=4 )


###################################################
### code chunk number 9: readGMT (eval = FALSE)
###################################################
## gsDataFile <- system.file( "extdata", "gsData.gmt", package="cnvGSAdata" )
## gsData_demo <- readGMT( gsDataFile )
## rm(gsDataFile)


###################################################
### code chunk number 10: Loading.gene.annotations.1
###################################################
str( geneData(input), strict.width="cut" )


###################################################
### code chunk number 11: Loading.annotations.from.org.Hs.eg.db (eval = FALSE)
###################################################
## library( "org.Hs.eg.db" )
## 
## ann <- list( gene2sy = character(0), gene2name = character(0) )
## 
## x <- org.Hs.egSYMBOL
## mapped_genes <- mappedkeys(x)
## ann$gene2sy <- unlist( as.list( x[mapped_genes] ) )
## 
## x <- org.Hs.egGENENAME
## mapped_genes <- mappedkeys(x)
## ann$gene2name <- unlist( as.list( x[mapped_genes] ) )
## 
## geneData_demo <- list(ann)
## 
## rm( ann, x, mapped_genes )


###################################################
### code chunk number 12: Configuring.test.parameters.1
###################################################
str( params(input) )


###################################################
### code chunk number 13: Configuring.test.parameters.2
###################################################
paramFile <- system.file( "scripts", "params_example.R", package="cnvGSA" )
params_demo <- readParamsRFile( paramFile )
rm(paramFile)


###################################################
### code chunk number 14: Configuring.test.parameters.3 (eval = FALSE)
###################################################
## cnvData_demo$filters <- params_demo$filters


###################################################
### code chunk number 15: Running.the.association.test.1 (eval = FALSE)
###################################################
## input_demo <- CnvGSAInput(
##     cnvData = cnvData_demo,
##     gsData = gsData_demo,
##     geneData = geneData_demo,
##     params = params_demo
## )
## rm( cnvData_demo, gsData_demo, geneData_demo, params_demo )


###################################################
### code chunk number 16: Running.the.association.test (eval = FALSE)
###################################################
## output <- cnvGSAFisher( input )


###################################################
### code chunk number 17: input.cleanup
###################################################
# Cleanup any input variables hanging around so that Sweave() won't pollute
options(width=100)


###################################################
### code chunk number 18: slotNames.output
###################################################
slotNames(output)


###################################################
### code chunk number 19: enrRes
###################################################
str( enrRes(output), max.level=1 )


###################################################
### code chunk number 20: enrRes.extended
###################################################
str( enrRes(output)$extended, max.level=1, strict.width="cut" )


###################################################
### code chunk number 21: FET.permFDR
###################################################
1 : max( which( enrRes(output)$basic$FET_permFDR <= 0.01 ) )


###################################################
### code chunk number 22: top20.setwidth
###################################################
options(width=100)


###################################################
### code chunk number 23: top20
###################################################
head( enrRes(output)$extended[ , c("FET_pv","FET_OR","FET_bhFDR","FET_permFDR",
"Topgene", "FETpv_remTop")], 20 )


###################################################
### code chunk number 24: top20.clearwidth
###################################################
options(width=80)


###################################################
### code chunk number 25: enrRes.geneData
###################################################
str( geneData(output), strict.width="wrap" )


###################################################
### code chunk number 26: geneData.gcounts
###################################################
head( geneData(output)$gcounts[ , -3] )


###################################################
### code chunk number 27: gstables
###################################################
str( enrRes(output)$gstables, max.level=1, list.len=5 )


###################################################
### code chunk number 28: gstables.dataframe.setwidth
###################################################
options(width=160)


###################################################
### code chunk number 29: gstables.dataframe
###################################################
enrRes(output)$gstables[[2]][10:19,]


###################################################
### code chunk number 30: burdenSample
###################################################
burdenSample(output)


###################################################
### code chunk number 31: burdenGs
###################################################
burdenGs(output)


