### R code from vignette source 'fmcsR.Rnw'

###################################################
### code chunk number 1: fmcsR.Rnw:63-64
###################################################
options(width=80)


###################################################
### code chunk number 2: fmcsR.Rnw:84-86 (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("fmcsR")


###################################################
### code chunk number 3: quicktest1
###################################################
library(fmcsR)
data(fmcstest)
plot(fmcstest[1:3], print=FALSE)


###################################################
### code chunk number 4: quicktest2
###################################################
test <- fmcs(fmcstest[1], fmcstest[2], au=2, bu=1)
plotMCS(test)


###################################################
### code chunk number 5: fmcsR.Rnw:121-122
###################################################
library("fmcsR") # Loads the package


###################################################
### code chunk number 6: fmcsR.Rnw:124-128 (eval = FALSE)
###################################################
## library(help="fmcsR") # Lists functions/classes provided by fmcsR 
## library(help="ChemmineR") # Lists functions/classes from ChemmineR
## vignette("fmcsR") # Opens this PDF manual
## vignette("ChemmineR") # Opens ChemmineR PDF manual


###################################################
### code chunk number 7: fmcsR.Rnw:132-135 (eval = FALSE)
###################################################
## ?fmcs
## ?"MCS-class"
## ?"SDFset-class"


###################################################
### code chunk number 8: fmcsR.Rnw:144-147
###################################################
data(fmcstest)
sdfset <- fmcstest
sdfset


###################################################
### code chunk number 9: fmcsR.Rnw:151-153 (eval = FALSE)
###################################################
## write.SDF(sdfset, file="sdfset.sdf")
## mysdf <- read.SDFset(file="sdfset.sdf")


###################################################
### code chunk number 10: fmcsR.Rnw:158-162
###################################################
mcsa <- fmcs(sdfset[[1]], sdfset[[2]])
mcsa
mcsb <- fmcs(sdfset[[1]], sdfset[[3]])
mcsb


###################################################
### code chunk number 11: fmcsR.Rnw:166-167
###################################################
fmcs(sdfset[1], sdfset[2], fast=TRUE)


###################################################
### code chunk number 12: fmcsR.Rnw:172-173
###################################################
slotNames(mcsa)


###################################################
### code chunk number 13: fmcsR.Rnw:177-182
###################################################
stats(mcsa) # or mcsa[["stats"]]
mcsa1 <- mcs1(mcsa) # or mcsa[["mcs1"]]
mcsa2 <- mcs2(mcsa) # or mcsa[["mcs2"]]
mcsa1[1] # returns SDFset component
mcsa1[[2]][1:2] # return first two index vectors


###################################################
### code chunk number 14: fmcsR.Rnw:186-188
###################################################
mcstosdfset <- mcs2sdfset(mcsa, type="new")
plot(mcstosdfset[[1]], print=FALSE)


###################################################
### code chunk number 15: fmcsR.Rnw:192-194
###################################################
mylist <- list(stats=stats(mcsa), mcs1=mcs1(mcsa), mcs2=mcs2(mcsa)) 
as(mylist, "MCS")


###################################################
### code chunk number 16: au0bu0
###################################################
plotMCS(fmcs(sdfset[1], sdfset[2], au=0, bu=0))


###################################################
### code chunk number 17: au1bu1
###################################################
plotMCS(fmcs(sdfset[1], sdfset[2], au=1, bu=1))


###################################################
### code chunk number 18: au2bu2
###################################################
plotMCS(fmcs(sdfset[1], sdfset[2], au=2, bu=2))


###################################################
### code chunk number 19: au0bu013
###################################################
plotMCS(fmcs(sdfset[1], sdfset[3], au=0, bu=0))


###################################################
### code chunk number 20: fmcsR.Rnw:244-247
###################################################
data(sdfsample) # Loads larger sample data set
sdf <- sdfsample
fmcsBatch(sdf[1], sdf[1:30], au=0, bu=0)


###################################################
### code chunk number 21: tree
###################################################
sdf <- sdf[1:7]
d <- sapply(cid(sdf), function(x) 
            fmcsBatch(sdf[x], sdf, au=0, bu=0, 
            matching.mode="aromatic")[,"Overlap_Coefficient"])
d
hc <- hclust(as.dist(1-d), method="complete")
plot(as.dendrogram(hc), edgePar=list(col=4, lwd=2), horiz=TRUE) 


###################################################
### code chunk number 22: au0bu024
###################################################
plotMCS(fmcs(sdf[3], sdf[7], au=0, bu=0, matching.mode="aromatic"))


###################################################
### code chunk number 23: sessionInfo
###################################################
sessionInfo()


