### R code from vignette source 'motifStack.Rnw'

###################################################
### code chunk number 1: DNAseqLogo
###################################################
library(motifStack)
pcm <- read.table(file.path(find.package("motifStack"), "extdata", "bin_SOLEXA.pcm"))
pcm <- pcm[,3:ncol(pcm)]
rownames(pcm) <- c("A","C","G","T")
motif <- pcm2pfm(pcm)
motif <- new("pfm", mat=motif, name="bin_SOLEXA")
plot(motif)
#try a different font
plot(motif, font="mono,Courier")
#try a different font and a different color group
motif@color <- colorset(colorScheme='basepairing')
plot(motif,font="Times")


###################################################
### code chunk number 2: fig1
###################################################
opar<-par(mfrow=c(3,1))
motif@color<-colorset(colorScheme='auto')
motif@name="bin_SOLEXA, font='Helvetica', color='auto'"
plot(motif)
motif@name="bin_SOLEXA, font='mono,Courier', color='auto'"
plot(motif, font="mono,Courier")
motif@color <- colorset(colorScheme='basepairing')
motif@name="bin_SOLEXA, font='mono,Courier', color='basepairing'"
plot(motif,font="Times")
par<-opar


###################################################
### code chunk number 3: AAseqLogo
###################################################
library(motifStack)
protein<-read.table(file.path(find.package("motifStack"),"extdata","cap.txt"))
protein<-t(protein[,1:20])
motif<-pcm2pfm(protein)
motif<-new("pfm", mat=motif, name="CAP", 
            color=colorset(alphabet="AA",colorScheme="chemistry"))
plot(motif)


###################################################
### code chunk number 4: fig2
###################################################
plot(motif)


###################################################
### code chunk number 5: seqLogoStack
###################################################
library(motifStack)
library("MotIV")
#####Database and Scores#####
jaspar <- MotIV::readPWMfile(file.path(find.package("MotIV"), "extdata", "jaspar2010.txt"))
jaspar.scores <- MotIV::readDBScores(file.path(find.package("MotIV"), "extdata", "jaspar2010_PCC_SWU.scores"))
#####Input#####
pcms<-readPCM(file.path(find.package("motifStack"), "extdata"),"pcm$")
pcms<-lapply(pcms,function(.ele){.ele<-.ele[,3:ncol(.ele)];rownames(.ele)<-c("A","C","G","T");.ele})
motifs<-lapply(pcms,pcm2pfm)

#####Analysis#####
foxa1.analysis.jaspar<-MotIV::motifMatch(inputPWM=motifs,
                                         align="SWU",cc="PCC",
                                         database=jaspar, DBscores=jaspar.scores,top=5)
#####Clustering#####
d <- MotIV::motifDistances(getPWM(foxa1.analysis.jaspar))
hc <- MotIV::motifHclust(d)

##reorder the motifs for plotMotifLogoStack
motifs<-motifs[hc$order]
motifs<-lapply(names(motifs), function(.ele, motifs){new("pfm",mat=motifs[[.ele]], name=.ele)},motifs)
##do alignment
motifs<-DNAmotifAlignment(motifs)
##plot stacks
plotMotifLogoStack(motifs, ncex=1.0)
plotMotifLogoStackWithTree(motifs, hc=hc)


###################################################
### code chunk number 6: fig3
###################################################
plotMotifLogoStack(motifs, ncex=1.0)


###################################################
### code chunk number 7: fig4
###################################################
plotMotifLogoStackWithTree(motifs, hc=hc)


###################################################
### code chunk number 8: motifStack.Rnw:164-165
###################################################
sessionInfo()


