/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMDocumentImplUtil;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenLocalNameIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenNamespaceIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenQNameIterator;

public class OMDocumentImpl
implements OMDocument,
OMContainerEx {
    protected OMElement documentElement;
    protected OMNode firstChild;
    protected OMNode lastChild;
    protected boolean done = false;
    protected OMXMLParserWrapper parserWrapper;
    protected String charSetEncoding = "UTF-8";
    protected String xmlVersion = "1.0";
    protected String isStandalone;
    protected OMFactory factory;

    public OMDocumentImpl() {
        this.done = true;
    }

    public OMDocumentImpl(OMElement documentElement, OMXMLParserWrapper parserWrapper) {
        this.documentElement = documentElement;
        this.parserWrapper = parserWrapper;
    }

    public OMDocumentImpl(OMXMLParserWrapper parserWrapper) {
        this.parserWrapper = parserWrapper;
    }

    public OMDocumentImpl(OMFactory factory) {
        this();
        this.factory = factory;
    }

    public OMDocumentImpl(OMXMLParserWrapper parserWrapper, OMFactory factory) {
        this(parserWrapper);
        this.factory = factory;
    }

    public OMDocumentImpl(OMElement documentElement, OMXMLParserWrapper parserWrapper, OMFactory factory) {
        this(documentElement, parserWrapper);
        this.factory = factory;
    }

    public OMElement getOMDocumentElement() {
        while (this.documentElement == null && this.parserWrapper != null) {
            this.parserWrapper.next();
        }
        return this.documentElement;
    }

    public void setOMDocumentElement(OMElement documentElement) {
        this.documentElement = documentElement;
    }

    public boolean isComplete() {
        return this.done;
    }

    public void setComplete(boolean state) {
        this.done = state;
    }

    public void buildNext() {
        if (this.parserWrapper != null && !this.parserWrapper.isCompleted()) {
            this.parserWrapper.next();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChild(OMNode child) {
        if (child instanceof OMElement) {
            if (this.documentElement != null) throw new OMException("Document element already exists");
            this.addChild((OMNodeImpl)child);
            this.documentElement = (OMElement)child;
            return;
        } else {
            this.addChild((OMNodeImpl)child);
        }
    }

    private void addChild(OMNodeImpl child) {
        if (this.firstChild == null) {
            this.firstChild = child;
            child.setPreviousOMSibling(null);
        } else {
            child.setPreviousOMSibling(this.lastChild);
            ((OMNodeEx)this.lastChild).setNextOMSibling(child);
        }
        child.setNextOMSibling(null);
        child.setParent(this);
        this.lastChild = child;
    }

    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    public Iterator getChildrenWithName(QName elementQName) {
        return new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
    }

    public Iterator getChildrenWithLocalName(String localName) {
        return new OMChildrenLocalNameIterator(this.getFirstOMChild(), localName);
    }

    public Iterator getChildrenWithNamespaceURI(String uri) {
        return new OMChildrenNamespaceIterator(this.getFirstOMChild(), uri);
    }

    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild;
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator omChildrenQNameIterator = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        OMNode omNode = null;
        if (omChildrenQNameIterator.hasNext()) {
            omNode = (OMNode)omChildrenQNameIterator.next();
        }
        return omNode != null && 1 == omNode.getType() ? (OMElement)omNode : null;
    }

    public void setFirstChild(OMNode firstChild) {
        this.firstChild = firstChild;
    }

    public void setLastChild(OMNode omNode) {
        this.lastChild = omNode;
    }

    public String getCharsetEncoding() {
        return this.charSetEncoding;
    }

    public void setCharsetEncoding(String charEncoding) {
        this.charSetEncoding = charEncoding;
    }

    public String isStandalone() {
        return this.isStandalone;
    }

    public void setStandalone(String isStandalone) {
        this.isStandalone = isStandalone;
    }

    public String getXMLVersion() {
        return this.xmlVersion;
    }

    public void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer, boolean includeXMLDeclaration) throws XMLStreamException {
        this.internalSerialize(writer, false, includeXMLDeclaration);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false, !((MTOMXMLStreamWriter)writer).isIgnoreXMLDeclaration());
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true, !((MTOMXMLStreamWriter)writer).isIgnoreXMLDeclaration());
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, new OMOutputFormat());
        this.internalSerializeAndConsume(writer);
        writer.flush();
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, new OMOutputFormat());
        this.internalSerialize(writer);
        writer.flush();
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerializeAndConsume(writer);
        writer.flush();
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerialize(writer);
        writer.flush();
    }

    public void internalSerialize(XMLStreamWriter writer, boolean includeXMLDeclaration) throws XMLStreamException {
        this.internalSerialize(writer, true, includeXMLDeclaration);
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache, boolean includeXMLDeclaration) throws XMLStreamException {
        OMDocumentImplUtil.internalSerialize(this, writer, cache, includeXMLDeclaration);
    }

    public OMFactory getOMFactory() {
        return this.getOMDocumentElement().getOMFactory();
    }
}

