/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.HashSet;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPDisjointWithHandler
extends TriplePredicateHandler {
    public TPDisjointWithHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_DISJOINT_WITH.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.getConsumer().addClassExpression(subject, false);
        this.getConsumer().addClassExpression(object, false);
        return !this.isSubjectOrObjectAnonymous(subject, object) && this.isSubjectAndObjectClassExpression(subject, object);
    }

    public boolean canHandle(IRI subject, IRI predicate, IRI object) {
        return super.canHandle(subject, predicate, object) && this.isSubjectAndObjectClassExpression(subject, object);
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
        operands.add(this.translateClassExpression(subject));
        operands.add(this.translateClassExpression(object));
        this.addAxiom(this.getDataFactory().getOWLDisjointClassesAxiom(operands, this.getPendingAnnotations()));
        this.consumeTriple(subject, predicate, object);
    }
}

