/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.blocking;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetFactory<E>
implements Serializable {
    private static final long serialVersionUID = 7071071962187693657L;
    protected Entry[] m_unusedEntries = new Entry[32];
    protected Entry[] m_entries = new Entry[16];
    protected int m_size = 0;
    protected int m_resizeThreshold = (int)(0.75 * (double)this.m_entries.length);

    public void clearNonpermanent() {
        for (int i = this.m_entries.length - 1; i >= 0; --i) {
            Entry entry = this.m_entries[i];
            while (entry != null) {
                Entry entry2 = entry.m_nextEntry;
                if (!entry.m_permanent) {
                    this.removeEntry(entry);
                    this.leaveEntry(entry);
                }
                entry = entry2;
            }
        }
    }

    public int sizeInMemory() {
        Entry entry;
        int n;
        int n2 = this.m_unusedEntries.length * 4 + this.m_entries.length * 4;
        for (n = this.m_unusedEntries.length - 1; n >= 0; --n) {
            entry = this.m_unusedEntries[n];
            while (entry != null) {
                n2 += entry.m_table.length * 4 + 24;
                entry = entry.m_nextEntry;
            }
        }
        for (n = this.m_entries.length - 1; n >= 0; --n) {
            entry = this.m_entries[n];
            while (entry != null) {
                n2 += entry.m_table.length * 4 + 24;
                entry = entry.m_nextEntry;
            }
        }
        return n2;
    }

    public void addReference(Set<E> set) {
        ++((Entry)set).m_referenceCount;
    }

    public void removeReference(Set<E> set) {
        Entry entry = (Entry)set;
        --entry.m_referenceCount;
        if (entry.m_referenceCount == 0 && !entry.m_permanent) {
            this.removeEntry(entry);
            this.leaveEntry(entry);
        }
    }

    public void makePermanent(Set<E> set) {
        ((Entry)set).m_permanent = true;
    }

    public Set<E> getSet(List<E> list) {
        int n;
        int n2 = 0;
        for (n = list.size() - 1; n >= 0; --n) {
            n2 += list.get(n).hashCode();
        }
        n = SetFactory.getIndexFor(n2, this.m_entries.length);
        Entry<Object> entry = this.m_entries[n];
        while (entry != null) {
            if (n2 == entry.m_hashCode && entry.equalsTo(list)) {
                return entry;
            }
            entry = entry.m_nextEntry;
        }
        entry = this.getEntry(list.size());
        entry.initialize(list, n2);
        entry.m_previousEntry = null;
        entry.m_nextEntry = this.m_entries[n];
        if (entry.m_nextEntry != null) {
            entry.m_nextEntry.m_previousEntry = entry;
        }
        this.m_entries[n] = entry;
        ++this.m_size;
        if (this.m_size > this.m_resizeThreshold) {
            this.resize();
        }
        return entry;
    }

    protected void resize() {
        Entry[] entryArray = new Entry[this.m_entries.length * 2];
        for (int i = 0; i < this.m_entries.length; ++i) {
            Entry entry = this.m_entries[i];
            while (entry != null) {
                Entry entry2 = entry.m_nextEntry;
                int n = SetFactory.getIndexFor(entry.m_hashCode, entryArray.length);
                entry.m_nextEntry = entryArray[n];
                entry.m_previousEntry = null;
                if (entry.m_nextEntry != null) {
                    entry.m_nextEntry.m_previousEntry = entry;
                }
                entryArray[n] = entry;
                entry = entry2;
            }
        }
        this.m_entries = entryArray;
        this.m_resizeThreshold = (int)(0.75 * (double)this.m_entries.length);
    }

    protected void removeEntry(Entry<E> entry) {
        int n;
        if (entry.m_nextEntry != null) {
            entry.m_nextEntry.m_previousEntry = entry.m_previousEntry;
        }
        if (entry.m_previousEntry != null) {
            entry.m_previousEntry.m_nextEntry = entry.m_nextEntry;
        }
        if (this.m_entries[n = SetFactory.getIndexFor(entry.m_hashCode, this.m_entries.length)] == entry) {
            this.m_entries[n] = entry.m_nextEntry;
        }
        entry.m_nextEntry = null;
        entry.m_previousEntry = null;
    }

    protected Entry<E> getEntry(int n) {
        Entry entry;
        if (n >= this.m_unusedEntries.length) {
            int n2 = this.m_unusedEntries.length;
            while (n2 <= n) {
                n2 = n2 * 3 / 2;
            }
            Entry[] entryArray = new Entry[n2];
            System.arraycopy(this.m_unusedEntries, 0, entryArray, 0, this.m_unusedEntries.length);
            this.m_unusedEntries = entryArray;
        }
        if ((entry = this.m_unusedEntries[n]) == null) {
            return new Entry(n);
        }
        this.m_unusedEntries[n] = entry.m_nextEntry;
        entry.m_nextEntry = null;
        return entry;
    }

    protected void leaveEntry(Entry<E> entry) {
        entry.m_nextEntry = this.m_unusedEntries[entry.size()];
        entry.m_previousEntry = null;
        this.m_unusedEntries[entry.size()] = entry;
    }

    protected static int getIndexFor(int n, int n2) {
        return n & n2 - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<T>
    implements Serializable,
    Set<T> {
        private static final long serialVersionUID = -3850593656120645350L;
        protected T[] m_table;
        protected int m_hashCode = 0;
        protected Entry<T> m_previousEntry;
        protected Entry<T> m_nextEntry;
        protected int m_referenceCount;
        protected boolean m_permanent;

        public Entry(int n) {
            this.m_table = new Object[n];
        }

        public void initialize(List<T> list, int n) {
            list.toArray(this.m_table);
            this.m_hashCode = n;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        public boolean equalsTo(List<T> list) {
            if (this.m_table.length != list.size()) {
                return false;
            }
            for (int i = this.m_table.length - 1; i >= 0; --i) {
                if (list.contains(this.m_table[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            for (int i = this.m_table.length - 1; i >= 0; --i) {
                if (!this.m_table[i].equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.m_table.length == 0;
        }

        @Override
        public Iterator<T> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.m_table.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.m_table.clone();
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            System.arraycopy(this.m_table, 0, EArray, 0, this.m_table.length);
            return EArray;
        }

        @Override
        public int hashCode() {
            return this.m_hashCode;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class EntryIterator
        implements Iterator<T> {
            protected int m_currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.m_currentIndex < Entry.this.m_table.length;
            }

            @Override
            public T next() {
                if (this.m_currentIndex >= Entry.this.m_table.length) {
                    throw new NoSuchElementException();
                }
                return Entry.this.m_table[this.m_currentIndex++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

