/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.datatypes.binarydata;

import java.util.Collection;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryData;
import org.semanticweb.HermiT.datatypes.binarydata.BinaryDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryDataLengthInterval {
    protected final BinaryDataType m_binaryDataType;
    protected final int m_minLength;
    protected final int m_maxLength;

    public BinaryDataLengthInterval(BinaryDataType binaryDataType, int n, int n2) {
        assert (!BinaryDataLengthInterval.isIntervalEmpty(binaryDataType, n, n2));
        this.m_binaryDataType = binaryDataType;
        this.m_minLength = n;
        this.m_maxLength = n2;
    }

    public BinaryDataLengthInterval intersectWith(BinaryDataLengthInterval binaryDataLengthInterval) {
        int n;
        if (this.m_binaryDataType != binaryDataLengthInterval.m_binaryDataType) {
            return null;
        }
        int n2 = Math.max(this.m_minLength, binaryDataLengthInterval.m_minLength);
        if (BinaryDataLengthInterval.isIntervalEmpty(this.m_binaryDataType, n2, n = Math.min(this.m_maxLength, binaryDataLengthInterval.m_maxLength))) {
            return null;
        }
        if (this.isEqual(this.m_binaryDataType, n2, n)) {
            return this;
        }
        if (binaryDataLengthInterval.isEqual(this.m_binaryDataType, n2, n)) {
            return binaryDataLengthInterval;
        }
        return new BinaryDataLengthInterval(this.m_binaryDataType, n2, n);
    }

    protected boolean isEqual(BinaryDataType binaryDataType, int n, int n2) {
        return this.m_binaryDataType == binaryDataType && this.m_minLength == n && this.m_maxLength == n2;
    }

    public int subtractSizeFrom(int n) {
        if (n <= 0 || this.m_maxLength == Integer.MAX_VALUE) {
            return 0;
        }
        if (this.m_minLength >= 7 || this.m_maxLength >= 7) {
            return 0;
        }
        long l = this.getNumberOfValuesOfLength(this.m_maxLength) - this.getNumberOfValuesOfLength(this.m_minLength - 1);
        return (int)Math.max((long)n - l, 0L);
    }

    protected long getNumberOfValuesOfLength(int n) {
        if (n < 0) {
            return 0L;
        }
        long l = 1L;
        long l2 = 1L;
        for (int i = 1; i <= n; ++i) {
            l2 += (l *= 256L);
        }
        return l2;
    }

    public boolean contains(BinaryData binaryData) {
        return this.m_binaryDataType == binaryData.getBinaryDataType() && this.m_minLength <= binaryData.getNumberOfBytes() && binaryData.getNumberOfBytes() <= this.m_maxLength;
    }

    public void enumerateValues(Collection<Object> collection) {
        if (this.m_maxLength == Integer.MAX_VALUE) {
            throw new IllegalStateException("Internal error: the data range is infinite!");
        }
        if (this.m_minLength == 0) {
            collection.add(new BinaryData(this.m_binaryDataType, new byte[0]));
        }
        byte[] byArray = new byte[this.m_maxLength];
        this.processPosition(byArray, collection, 0);
    }

    protected void processPosition(byte[] byArray, Collection<Object> collection, int n) {
        if (n < this.m_maxLength) {
            for (int i = 0; i <= 255; ++i) {
                byArray[n] = (byte)i;
                if (this.m_minLength <= n + 1) {
                    byte[] byArray2 = new byte[n + 1];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                    collection.add(new BinaryData(this.m_binaryDataType, byArray2));
                }
                this.processPosition(byArray, collection, n + 1);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_binaryDataType.toString());
        stringBuffer.append('[');
        stringBuffer.append(this.m_minLength);
        stringBuffer.append("..");
        if (this.m_maxLength == Integer.MAX_VALUE) {
            stringBuffer.append("+INF");
        } else {
            stringBuffer.append(this.m_maxLength);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected static boolean isIntervalEmpty(BinaryDataType binaryDataType, int n, int n2) {
        return n > n2;
    }
}

