/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.model.DLClause;

public class ShowDLClausesCommand
extends AbstractCommand {
    public ShowDLClausesCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "showDLClauses";
    }

    public String[] getDescription() {
        return new String[]{"", "prints the currently used set of DL-clauses"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: showDLClauses");
        printWriter.println("    Prints the currently used set of DL-clauses.");
    }

    public void execute(String[] stringArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        if (!this.m_debugger.getTableau().getPermanentDLOntology().getDLClauses().isEmpty()) {
            printWriter.println("-----------------------------------------------");
            printWriter.println("Permanent DL-clauses:");
            printWriter.println("-----------------------------------------------");
            for (DLClause dLClause : this.m_debugger.getTableau().getPermanentDLOntology().getDLClauses()) {
                printWriter.println(dLClause.toString(this.m_debugger.getPrefixes()));
            }
        }
        if (this.m_debugger.getTableau().getAdditionalDLOntology() != null && !this.m_debugger.getTableau().getAdditionalDLOntology().getDLClauses().isEmpty()) {
            printWriter.println("-----------------------------------------------");
            printWriter.println("Additional DL-clauses:");
            printWriter.println("-----------------------------------------------");
            for (DLClause dLClause : this.m_debugger.getTableau().getAdditionalDLOntology().getDLClauses()) {
                printWriter.println(dLClause.toString(this.m_debugger.getPrefixes()));
            }
        }
        printWriter.flush();
        this.showTextInWindow(charArrayWriter.toString(), "DL-clauses");
        this.selectConsoleWindow();
    }
}

