/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import org.semanticweb.HermiT.tableau.TupleTable;

public final class TupleTableFullIndex
implements Serializable {
    private static final long serialVersionUID = 5006873858554891684L;
    protected static final int BUCKET_OFFSET = 1;
    protected static final float LOAD_FACTOR = 0.75f;
    protected final TupleTable m_tupleTable;
    protected final int m_indexedArity;
    protected final EntryManager m_entryManager;
    protected int[] m_buckets;
    protected int m_resizeThreshold;
    protected int m_numberOfTuples;
    protected static final int ENTRY_SIZE = 3;
    protected static final int ENTRY_NEXT = 0;
    protected static final int ENTRY_HASH_CODE = 1;
    protected static final int ENTRY_TUPLE_INDEX = 2;
    protected static final int ENTRY_PAGE_SIZE = 512;

    public TupleTableFullIndex(TupleTable tupleTable, int n) {
        this.m_tupleTable = tupleTable;
        this.m_indexedArity = n;
        this.m_entryManager = new EntryManager();
        this.clear();
    }

    public int sizeInMemory() {
        return this.m_buckets.length * 4 + this.m_entryManager.size();
    }

    public void clear() {
        this.m_buckets = new int[16];
        this.m_resizeThreshold = (int)((float)this.m_buckets.length * 0.75f);
        this.m_entryManager.clear();
    }

    public int addTuple(Object[] objectArray, int n) {
        int n2 = this.getTupleHashCode(objectArray);
        int n3 = TupleTableFullIndex.getBucketIndex(n2, this.m_buckets.length);
        int n4 = this.m_buckets[n3] - 1;
        while (n4 != -1) {
            int n5;
            if (n2 == this.m_entryManager.getEntryComponent(n4, 1) && this.m_tupleTable.tupleEquals(objectArray, n5 = this.m_entryManager.getEntryComponent(n4, 2), this.m_indexedArity)) {
                return n5;
            }
            n4 = this.m_entryManager.getEntryComponent(n4, 0);
        }
        n4 = this.m_entryManager.newEntry();
        this.m_entryManager.setEntryComponent(n4, 0, this.m_buckets[n3] - 1);
        this.m_entryManager.setEntryComponent(n4, 1, n2);
        this.m_entryManager.setEntryComponent(n4, 2, n);
        this.m_buckets[n3] = n4 + 1;
        ++this.m_numberOfTuples;
        if (this.m_numberOfTuples >= this.m_resizeThreshold) {
            this.resizeBuckets();
        }
        return n;
    }

    protected void resizeBuckets() {
        int[] nArray = new int[this.m_buckets.length * 2];
        for (int i = this.m_buckets.length - 1; i >= 0; --i) {
            int n = this.m_buckets[i] - 1;
            while (n != -1) {
                int n2 = this.m_entryManager.getEntryComponent(n, 0);
                int n3 = TupleTableFullIndex.getBucketIndex(this.m_entryManager.getEntryComponent(n, 1), nArray.length);
                this.m_entryManager.setEntryComponent(n, 0, nArray[n3] - 1);
                nArray[n3] = n + 1;
                n = n2;
            }
        }
        this.m_buckets = nArray;
        this.m_resizeThreshold = (int)((float)nArray.length * 0.75f);
    }

    public int getTupleIndex(Object[] objectArray) {
        int n = this.getTupleHashCode(objectArray);
        int n2 = TupleTableFullIndex.getBucketIndex(n, this.m_buckets.length);
        int n3 = this.m_buckets[n2] - 1;
        while (n3 != -1) {
            int n4;
            if (n == this.m_entryManager.getEntryComponent(n3, 1) && this.m_tupleTable.tupleEquals(objectArray, n4 = this.m_entryManager.getEntryComponent(n3, 2), this.m_indexedArity)) {
                return n4;
            }
            n3 = this.m_entryManager.getEntryComponent(n3, 0);
        }
        return -1;
    }

    public int getTupleIndex(Object[] objectArray, int[] nArray) {
        int n = this.getTupleHashCode(objectArray, nArray);
        int n2 = TupleTableFullIndex.getBucketIndex(n, this.m_buckets.length);
        int n3 = this.m_buckets[n2] - 1;
        while (n3 != -1) {
            int n4;
            if (n == this.m_entryManager.getEntryComponent(n3, 1) && this.m_tupleTable.tupleEquals(objectArray, nArray, n4 = this.m_entryManager.getEntryComponent(n3, 2), this.m_indexedArity)) {
                return n4;
            }
            n3 = this.m_entryManager.getEntryComponent(n3, 0);
        }
        return -1;
    }

    public boolean removeTuple(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.m_indexedArity; ++n2) {
            n3 += this.m_tupleTable.getTupleObject(n, n2).hashCode();
        }
        n2 = -1;
        int n4 = TupleTableFullIndex.getBucketIndex(n3, this.m_buckets.length);
        int n5 = this.m_buckets[n4] - 1;
        while (n5 != -1) {
            int n6 = this.m_entryManager.getEntryComponent(n5, 0);
            if (n3 == this.m_entryManager.getEntryComponent(n5, 1) && n == this.m_entryManager.getEntryComponent(n5, 2)) {
                if (n2 == -1) {
                    this.m_buckets[n4] = n6 + 1;
                } else {
                    this.m_entryManager.setEntryComponent(n2, 0, n6);
                }
                return true;
            }
            n2 = n5;
            n5 = n6;
        }
        return false;
    }

    protected int getTupleHashCode(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < this.m_indexedArity; ++i) {
            n += objectArray[i].hashCode();
        }
        return n;
    }

    protected int getTupleHashCode(Object[] objectArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.m_indexedArity; ++i) {
            n += objectArray[nArray[i]].hashCode();
        }
        return n;
    }

    protected static int getBucketIndex(int n, int n2) {
        return n & n2 - 1;
    }

    protected static final class EntryManager
    implements Serializable {
        private static final long serialVersionUID = -7562640774004213308L;
        protected int[] m_entries;
        protected int m_firstFreeEntry;

        public EntryManager() {
            this.clear();
        }

        public int size() {
            return this.m_entries.length * 4;
        }

        public void clear() {
            this.m_entries = new int[1536];
            this.m_firstFreeEntry = 0;
            this.m_entries[this.m_firstFreeEntry + 0] = -1;
        }

        public int getEntryComponent(int n, int n2) {
            return this.m_entries[n + n2];
        }

        public void setEntryComponent(int n, int n2, int n3) {
            this.m_entries[n + n2] = n3;
        }

        public int newEntry() {
            int n = this.m_firstFreeEntry;
            int n2 = this.m_entries[this.m_firstFreeEntry + 0];
            if (n2 == -1) {
                this.m_firstFreeEntry += 3;
                if (this.m_firstFreeEntry >= this.m_entries.length) {
                    int[] nArray = new int[this.m_entries.length + 1536];
                    System.arraycopy(this.m_entries, 0, nArray, 0, this.m_entries.length);
                    this.m_entries = nArray;
                }
                this.m_entries[this.m_firstFreeEntry + 0] = -1;
            } else {
                this.m_firstFreeEntry = n2;
            }
            return n;
        }

        public void deleteEntry(int n) {
            this.m_entries[n + 0] = this.m_firstFreeEntry;
            this.m_firstFreeEntry = n;
        }
    }
}

