/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;

public interface OWLOntologyLoaderListener {
    public void startedLoadingOntology(LoadingStartedEvent var1);

    public void finishedLoadingOntology(LoadingFinishedEvent var1);

    public static class LoadingFinishedEvent
    extends LoadingEvent {
        private OWLOntologyCreationException ex;

        public LoadingFinishedEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported, OWLOntologyCreationException ex) {
            super(ontologyID, documentIRI, imported);
            this.ex = ex;
        }

        public boolean isSuccessful() {
            return this.ex == null;
        }

        public OWLOntologyCreationException getException() {
            return this.ex;
        }
    }

    public static class LoadingStartedEvent
    extends LoadingEvent {
        public LoadingStartedEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported) {
            super(ontologyID, documentIRI, imported);
        }
    }

    public static class LoadingEvent {
        private OWLOntologyID ontologyID;
        private IRI documentIRI;
        private boolean imported;

        public LoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported) {
            this.ontologyID = ontologyID;
            this.documentIRI = documentIRI;
            this.imported = imported;
        }

        public OWLOntologyID getOntologyID() {
            return this.ontologyID;
        }

        public IRI getDocumentIRI() {
            return this.documentIRI;
        }

        public boolean isImported() {
            return this.imported;
        }
    }
}

