/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralTransformation {
    protected OWLDataFactory df;
    private int nameCounter = 0;
    protected Set<OWLEntity> signature;

    public StructuralTransformation(OWLDataFactory dataFactory) {
        this.df = dataFactory;
        this.signature = new HashSet<OWLEntity>();
    }

    protected OWLClass createNewName() {
        OWLClass cls = this.df.getOWLClass(IRI.create("http://www.semanticweb.org/ontology#X" + this.nameCounter));
        ++this.nameCounter;
        return cls;
    }

    public Set<OWLAxiom> getTransformedAxioms(Set<OWLAxiom> axioms) {
        this.signature.clear();
        for (OWLAxiom ax : axioms) {
            this.signature.addAll(ax.getSignature());
        }
        AxiomRewriter rewriter = new AxiomRewriter();
        HashSet<OWLAxiom> transformedAxioms = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : axioms) {
            for (OWLAxiom transAx : ax.accept(rewriter)) {
                if (transAx instanceof OWLSubClassOfAxiom) {
                    AxiomFlattener flattener = new AxiomFlattener(this.df, ((OWLSubClassOfAxiom)transAx).getSuperClass());
                    Set<OWLAxiom> flattenedAxioms = flattener.getAxioms();
                    if (!flattenedAxioms.isEmpty()) {
                        transformedAxioms.addAll(flattenedAxioms);
                        continue;
                    }
                    transformedAxioms.add(transAx);
                    continue;
                }
                transformedAxioms.add(transAx);
            }
        }
        return transformedAxioms;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomRewriter
    implements OWLAxiomVisitorEx<Set<OWLAxiom>> {
        private AxiomRewriter() {
        }

        private Set<OWLAxiom> subClassOf(OWLClassExpression sub, OWLClassExpression sup) {
            return Collections.singleton(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectUnionOf(StructuralTransformation.this.df.getOWLObjectComplementOf(sub), sup).getNNF()));
        }

        private Set<OWLAxiom> toSet(OWLAxiom ax) {
            return Collections.singleton(ax);
        }

        @Override
        public Set<OWLAxiom> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLClassAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getIndividual()), axiom.getClassExpression());
        }

        @Override
        public Set<OWLAxiom> visit(OWLDataPropertyAssertionAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLDataPropertyDomainAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getTopDatatype()), axiom.getDomain());
        }

        @Override
        public Set<OWLAxiom> visit(OWLDataPropertyRangeAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)axiom.getRange())));
        }

        @Override
        public Set<OWLAxiom> visit(OWLSubDataPropertyOfAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLDeclarationAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLDifferentIndividualsAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList<OWLIndividual> individuals = new ArrayList<OWLIndividual>(axiom.getIndividuals());
            for (int i = 0; i < individuals.size(); ++i) {
                for (int j = i + 1; j < individuals.size(); ++j) {
                    axioms.addAll(this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)individuals.get(i)), StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)individuals.get(j))));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLDisjointClassesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList<OWLClassExpression> classExpressions = new ArrayList<OWLClassExpression>(axiom.getClassExpressions());
            for (int i = 0; i < classExpressions.size(); ++i) {
                for (int j = i + 1; j < classExpressions.size(); ++j) {
                    axioms.addAll(this.subClassOf((OWLClassExpression)classExpressions.get(i), (OWLClassExpression)classExpressions.get(j)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLDisjointDataPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList props = new ArrayList(axiom.getProperties());
            for (int i = 0; i < props.size(); ++i) {
                for (int j = i + 1; j < props.size(); ++j) {
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointDataPropertiesAxiom((OWLDataPropertyExpression)props.get(i), (OWLDataPropertyExpression)props.get(j)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLDisjointObjectPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList props = new ArrayList(axiom.getProperties());
            for (int i = 0; i < props.size(); ++i) {
                for (int j = i + 1; j < props.size(); ++j) {
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)props.get(i), (OWLObjectPropertyExpression)props.get(j)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLDisjointUnionAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            axioms.addAll((Collection)StructuralTransformation.this.df.getOWLEquivalentClassesAxiom((OWLClassExpression)axiom.getOWLClass(), (OWLClassExpression)StructuralTransformation.this.df.getOWLObjectUnionOf(axiom.getClassExpressions())).accept(this));
            axioms.addAll((Collection)StructuralTransformation.this.df.getOWLDisjointClassesAxiom(axiom.getClassExpressions()).accept(this));
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLAnnotationAssertionAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLEquivalentClassesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList<OWLClassExpression> classExpressions = new ArrayList<OWLClassExpression>(axiom.getClassExpressions());
            for (int i = 0; i < classExpressions.size(); ++i) {
                for (int j = i + 1; j < classExpressions.size(); ++j) {
                    axioms.addAll(this.subClassOf((OWLClassExpression)classExpressions.get(i), (OWLClassExpression)classExpressions.get(j)));
                    axioms.addAll(this.subClassOf((OWLClassExpression)classExpressions.get(j), (OWLClassExpression)classExpressions.get(i)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLEquivalentDataPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList props = new ArrayList(axiom.getProperties());
            for (int i = 0; i < props.size(); ++i) {
                for (int j = i + 1; j < props.size(); ++j) {
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointDataPropertiesAxiom((OWLDataPropertyExpression)props.get(i), (OWLDataPropertyExpression)props.get(j)));
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointDataPropertiesAxiom((OWLDataPropertyExpression)props.get(j), (OWLDataPropertyExpression)props.get(i)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            ArrayList props = new ArrayList(axiom.getProperties());
            for (int i = 0; i < props.size(); ++i) {
                for (int j = i + 1; j < props.size(); ++j) {
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)props.get(i), (OWLObjectPropertyExpression)props.get(j)));
                    axioms.add(StructuralTransformation.this.df.getOWLDisjointObjectPropertiesAxiom((OWLObjectPropertyExpression)props.get(j), (OWLObjectPropertyExpression)props.get(i)));
                }
            }
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLFunctionalDataPropertyAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)axiom.getProperty())));
        }

        @Override
        public Set<OWLAxiom> visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)axiom.getProperty())));
        }

        @Override
        public Set<OWLAxiom> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectMaxCardinality(1, ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty())));
        }

        @Override
        public Set<OWLAxiom> visit(OWLInverseObjectPropertiesAxiom axiom) {
            HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
            axioms.add(StructuralTransformation.this.df.getOWLSubObjectPropertyOfAxiom(axiom.getFirstProperty(), axiom.getSecondProperty().getInverseProperty()));
            axioms.add(StructuralTransformation.this.df.getOWLSubObjectPropertyOfAxiom(axiom.getSecondProperty(), axiom.getFirstProperty().getInverseProperty()));
            return axioms;
        }

        @Override
        public Set<OWLAxiom> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getSubject()), StructuralTransformation.this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLDataComplementOf(StructuralTransformation.this.df.getOWLDataOneOf((OWLLiteral)axiom.getObject()))));
        }

        @Override
        public Set<OWLAxiom> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectOneOf(axiom.getSubject()), StructuralTransformation.this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLObjectComplementOf(StructuralTransformation.this.df.getOWLObjectOneOf((OWLIndividual)axiom.getObject()))));
        }

        @Override
        public Set<OWLAxiom> visit(OWLObjectPropertyAssertionAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLSubPropertyChainOfAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLObjectPropertyDomainAxiom axiom) {
            return this.subClassOf(StructuralTransformation.this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), StructuralTransformation.this.df.getOWLThing()), axiom.getDomain());
        }

        @Override
        public Set<OWLAxiom> visit(OWLObjectPropertyRangeAxiom axiom) {
            return this.toSet(StructuralTransformation.this.df.getOWLSubClassOfAxiom(StructuralTransformation.this.df.getOWLThing(), StructuralTransformation.this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getRange())));
        }

        @Override
        public Set<OWLAxiom> visit(OWLSubObjectPropertyOfAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLSameIndividualAxiom axiom) {
            return null;
        }

        @Override
        public Set<OWLAxiom> visit(OWLSubClassOfAxiom axiom) {
            return this.subClassOf(axiom.getSubClass(), axiom.getSuperClass());
        }

        @Override
        public Set<OWLAxiom> visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(SWRLRule rule) {
            return this.toSet(rule);
        }

        @Override
        public Set<OWLAxiom> visit(OWLHasKeyAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLAnnotationPropertyDomainAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLAnnotationPropertyRangeAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            return this.toSet(axiom);
        }

        @Override
        public Set<OWLAxiom> visit(OWLDatatypeDefinitionAxiom axiom) {
            return this.toSet(axiom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxiomFlattener
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        private OWLDataFactory df;
        private Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        private OWLClassExpression rhs;

        public AxiomFlattener(OWLDataFactory df, OWLClassExpression rhs) {
            this.df = df;
            this.rhs = rhs;
        }

        private OWLSubClassOfAxiom getSCA(OWLClass lhs, OWLClassExpression rhs) {
            return this.df.getOWLSubClassOfAxiom(lhs, rhs);
        }

        public Set<OWLAxiom> getAxioms() {
            this.axioms.clear();
            OWLClass lhs = this.df.getOWLThing();
            OWLClassExpression rhs2 = this.rhs.accept(this);
            this.axioms.add(this.getSCA(lhs, rhs2));
            return this.axioms;
        }

        @Override
        public OWLClassExpression visit(OWLClass desc) {
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLDataAllValuesFrom desc) {
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLDataExactCardinality desc) {
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLDataMaxCardinality desc) {
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLDataMinCardinality desc) {
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLDataSomeValuesFrom desc) {
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLDataHasValue desc) {
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectAllValuesFrom desc) {
            if (StructuralTransformation.this.signature.containsAll(((OWLClassExpression)desc.getFiller()).getSignature())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLClassExpression rhs = ((OWLClassExpression)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), name);
            }
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectComplementOf desc) {
            if (desc.getOperand().isAnonymous()) {
                throw new IllegalStateException("Negation of arbitrary class expressions not allowed");
            }
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectExactCardinality desc) {
            if (StructuralTransformation.this.signature.containsAll(((OWLClassExpression)desc.getFiller()).getSignature())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLClassExpression rhs = ((OWLClassExpression)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectExactCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), name);
            }
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectIntersectionOf desc) {
            OWLClass name = StructuralTransformation.this.createNewName();
            for (OWLClassExpression op : desc.getOperands()) {
                OWLClassExpression flatOp = op.accept(this);
                this.axioms.add(this.getSCA(name, flatOp));
            }
            return name;
        }

        @Override
        public OWLClassExpression visit(OWLObjectMaxCardinality desc) {
            if (StructuralTransformation.this.signature.containsAll(((OWLClassExpression)desc.getFiller()).getSignature())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLClassExpression rhs = ((OWLClassExpression)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectMaxCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), name);
            }
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectMinCardinality desc) {
            if (StructuralTransformation.this.signature.containsAll(((OWLClassExpression)desc.getFiller()).getSignature())) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLClassExpression rhs = ((OWLClassExpression)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectMinCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), name);
            }
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectOneOf desc) {
            if (desc.getIndividuals().size() > 1) {
                throw new IllegalStateException("ObjectOneOf with more than one individual!");
            }
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasSelf desc) {
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectSomeValuesFrom desc) {
            if (((OWLClassExpression)desc.getFiller()).isAnonymous()) {
                OWLClass name = StructuralTransformation.this.createNewName();
                OWLClassExpression rhs = ((OWLClassExpression)desc.getFiller()).accept(this);
                this.axioms.add(this.getSCA(name, rhs));
                return this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), name);
            }
            return desc;
        }

        @Override
        public OWLClassExpression visit(OWLObjectUnionOf desc) {
            HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
            for (OWLClassExpression op : desc.getOperands()) {
                OWLClassExpression flatOp = op.accept(this);
                if (flatOp.isAnonymous() || StructuralTransformation.this.signature.contains(flatOp.asOWLClass())) {
                    OWLClass name = StructuralTransformation.this.createNewName();
                    descs.add(name);
                    this.axioms.add(this.df.getOWLSubClassOfAxiom(name, flatOp));
                    continue;
                }
                descs.add(flatOp);
            }
            return this.df.getOWLObjectUnionOf(descs);
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasValue desc) {
            return desc;
        }
    }
}

