/*
 * Decompiled with CFR 0.152.
 */
package rationals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rationals.Acceptor;
import rationals.Couple;
import rationals.DefaultStateFactory;
import rationals.NoSuchStateException;
import rationals.Rational;
import rationals.State;
import rationals.StateFactory;
import rationals.StateMachine;
import rationals.Transition;
import rationals.converters.toAscii;
import rationals.transformations.TransformationsToolBox;

public class Automaton
implements Acceptor,
StateMachine,
Rational,
Cloneable {
    private Object id;
    protected Set alphabet;
    private Set states;
    private Set initials;
    private Set terminals;
    private Map transitions;
    private Map reverse;
    private StateFactory stateFactory = new DefaultStateFactory(this);

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public StateFactory getStateFactory() {
        return this.stateFactory;
    }

    public void setStateFactory(StateFactory factory) {
        this.stateFactory = factory;
        factory.setAutomaton(this);
    }

    public static Automaton epsilonAutomaton() {
        Automaton v = new Automaton();
        v.addState(true, true);
        return v;
    }

    public static Automaton labelAutomaton(Object label) {
        Automaton v = new Automaton();
        State start = v.addState(true, false);
        State end = v.addState(false, true);
        try {
            v.addTransition(new Transition(start, label, end));
        }
        catch (NoSuchStateException x) {
            // empty catch block
        }
        return v;
    }

    public static Automaton labelAutomaton(List word) {
        Automaton v = new Automaton();
        State start = null;
        if (word.isEmpty()) {
            v.addState(true, true);
            return v;
        }
        start = v.addState(true, false);
        State end = null;
        try {
            Iterator i = word.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                end = v.addState(false, !i.hasNext());
                v.addTransition(new Transition(start, o, end));
                start = end;
            }
        }
        catch (NoSuchStateException x) {
            // empty catch block
        }
        return v;
    }

    public Automaton() {
        this(null);
    }

    public Automaton(StateFactory sf) {
        this.stateFactory = sf == null ? new DefaultStateFactory(this) : sf;
        this.alphabet = new HashSet();
        this.states = this.stateFactory.stateSet();
        this.initials = this.stateFactory.stateSet();
        this.terminals = this.stateFactory.stateSet();
        this.transitions = new HashMap();
        this.reverse = new HashMap();
    }

    public State addState(boolean initial, boolean terminal) {
        State state = this.stateFactory.create(initial, terminal);
        if (initial) {
            this.initials.add(state);
        }
        if (terminal) {
            this.terminals.add(state);
        }
        this.states.add(state);
        return state;
    }

    public Set alphabet() {
        return this.alphabet;
    }

    public Set states() {
        return this.states;
    }

    public Set initials() {
        return this.initials;
    }

    public Set terminals() {
        return this.terminals;
    }

    protected Set access(Set start, Map map) {
        Set old;
        Set current = start;
        do {
            old = current;
            current = this.stateFactory.stateSet();
            Iterator i = old.iterator();
            while (i.hasNext()) {
                State e = (State)i.next();
                current.add(e);
                Iterator j = this.alphabet.iterator();
                while (j.hasNext()) {
                    Iterator k = this.find(map, e, j.next()).iterator();
                    while (k.hasNext()) {
                        current.add(((Transition)k.next()).end());
                    }
                }
            }
        } while (current.size() != old.size());
        return current;
    }

    public Set accessibleStates() {
        return this.access(this.initials, this.transitions);
    }

    public Set accessibleStates(Set states) {
        return this.access(states, this.transitions);
    }

    public Set accessibleStates(State state) {
        Set s = this.stateFactory.stateSet();
        s.add(state);
        return this.access(s, this.transitions);
    }

    public Set coAccessibleStates(Set states) {
        return this.access(states, this.reverse);
    }

    public Set coAccessibleStates() {
        return this.access(this.terminals, this.reverse);
    }

    public Set accessibleAndCoAccessibleStates() {
        Set ac = this.accessibleStates();
        ac.retainAll(this.coAccessibleStates());
        return ac;
    }

    protected Set find(Map m, State e, Object l) {
        Key n = new Key(e, l);
        if (!m.containsKey(n)) {
            return new HashSet();
        }
        return (Set)m.get(n);
    }

    protected void add(Map m, Transition t) {
        Set<Transition> s;
        Key n = new Key(t.start(), t.label());
        if (!m.containsKey(n)) {
            s = new HashSet();
            m.put(n, s);
        } else {
            s = (Set)m.get(n);
        }
        s.add(t);
    }

    public Set delta() {
        HashSet s = new HashSet();
        Iterator i = this.transitions.values().iterator();
        while (i.hasNext()) {
            s.addAll((Set)i.next());
        }
        return s;
    }

    public Set delta(State state, Object label) {
        return this.find(this.transitions, state, label);
    }

    public Set deltaFrom(State from, State to) {
        Set t = this.delta(from);
        Iterator i = t.iterator();
        while (i.hasNext()) {
            Transition tr = (Transition)i.next();
            if (to.equals(tr.end())) continue;
            i.remove();
        }
        return t;
    }

    public Set delta(State state) {
        HashSet s = new HashSet();
        Iterator alphit = this.alphabet().iterator();
        while (alphit.hasNext()) {
            s.addAll(this.delta(state, alphit.next()));
        }
        return s;
    }

    public Set delta(Set s) {
        HashSet ds = new HashSet();
        Iterator i = s.iterator();
        while (i.hasNext()) {
            ds.addAll(this.delta((State)i.next()));
        }
        return ds;
    }

    public Map couples() {
        Iterator it = this.transitions.entrySet().iterator();
        HashMap<Couple, HashSet<Transition>> ret = new HashMap<Couple, HashSet<Transition>>();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            State st = ((Key)e.getKey()).s;
            Iterator trans = ((Set)e.getValue()).iterator();
            while (trans.hasNext()) {
                Transition tr = (Transition)trans.next();
                State nd = tr.end();
                Couple cpl = new Couple(st, nd);
                HashSet<Transition> s = (HashSet<Transition>)ret.get(cpl);
                if (s == null) {
                    s = new HashSet<Transition>();
                }
                s.add(tr);
                ret.put(cpl, s);
            }
        }
        return ret;
    }

    public Set deltaMinusOne(State state, Object label) {
        return this.find(this.reverse, state, label);
    }

    public void addTransition(Transition transition) throws NoSuchStateException {
        if (!this.states.contains(transition.start()) || !this.states.contains(transition.end())) {
            throw new NoSuchStateException();
        }
        if (!this.alphabet.contains(transition.label())) {
            this.alphabet.add(transition.label());
        }
        this.add(this.transitions, transition);
        this.add(this.reverse, new Transition(transition.end(), transition.label(), transition.start()));
    }

    public void projectOn(Set alph) {
        Iterator trans = this.transitions.entrySet().iterator();
        HashSet<Transition> newtrans = new HashSet<Transition>();
        while (trans.hasNext()) {
            Map.Entry entry = trans.next();
            Key k = (Key)entry.getKey();
            Iterator tit = ((Set)entry.getValue()).iterator();
            while (tit.hasNext()) {
                Transition tr = (Transition)tit.next();
                if (alph.contains(k.l)) continue;
                newtrans.add(new Transition(k.s, null, tr.end()));
                tit.remove();
            }
        }
        if (!newtrans.isEmpty()) {
            trans = newtrans.iterator();
            while (trans.hasNext()) {
                Transition tr = (Transition)((Object)trans.next());
                this.add(this.transitions, tr);
                this.add(this.reverse, new Transition(tr.end(), tr.label(), tr.start()));
            }
        }
        this.alphabet.retainAll(alph);
    }

    public String toString() {
        return new toAscii().toString(this);
    }

    public Object clone() {
        Automaton b = new Automaton();
        HashMap<State, State> map = new HashMap<State, State>();
        Iterator i = this.states().iterator();
        while (i.hasNext()) {
            State e = (State)i.next();
            map.put(e, b.addState(e.isInitial(), e.isTerminal()));
        }
        i = this.delta().iterator();
        while (i.hasNext()) {
            Transition t = (Transition)i.next();
            try {
                b.addTransition(new Transition((State)map.get(t.start()), t.label(), (State)map.get(t.end())));
            }
            catch (NoSuchStateException x) {}
        }
        return b;
    }

    public boolean prefixProjection(List word) {
        Set s = this.stepsProject(word);
        return !s.isEmpty();
    }

    public Set stepsProject(List word) {
        Set s = this.initials();
        Iterator it = word.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!this.alphabet.contains(o) || !(s = this.step(s, o)).isEmpty()) continue;
            return s;
        }
        return s;
    }

    public boolean accept(List word) {
        Set s = TransformationsToolBox.epsilonClosure(this.steps(word), this);
        s.retainAll(this.terminals());
        return !s.isEmpty();
    }

    public boolean accept(State state, List word) {
        Set s = this.stateFactory.stateSet();
        s.add(state);
        return !this.steps(s, word).isEmpty();
    }

    public Set steps(List word) {
        Set s = TransformationsToolBox.epsilonClosure(this.initials(), this);
        return this.steps(s, word);
    }

    public Set steps(Set s, List word) {
        Iterator it = word.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(s = this.step(s, o)).isEmpty()) continue;
            return s;
        }
        return s;
    }

    public Set steps(State st, List word) {
        Set s = this.stateFactory.stateSet();
        s.add(st);
        Iterator it = word.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(s = this.step(s, o)).isEmpty()) continue;
            return s;
        }
        return s;
    }

    public List traceStates(List word, State start) {
        ArrayList<Set> ret = new ArrayList<Set>();
        Set s = null;
        if (start != null) {
            s = this.stateFactory.stateSet();
            s.add(start);
        } else {
            s = this.initials();
        }
        Iterator it = word.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!this.alphabet.contains(o)) continue;
            s = this.step(s, o);
            ret.add(s);
            if (!s.isEmpty()) continue;
            return null;
        }
        return ret;
    }

    public int longestPrefixWithProjection(List word) {
        int lret = 0;
        Set s = this.initials();
        Iterator it = word.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null || !this.alphabet.contains(o)) {
                ++lret;
                continue;
            }
            if ((s = this.step(s, o)).isEmpty()) break;
            ++lret;
        }
        return lret;
    }

    public Set step(Set s, Object o) {
        Set ns = this.stateFactory.stateSet();
        Set ec = TransformationsToolBox.epsilonClosure(s, this);
        Iterator it = ec.iterator();
        while (it.hasNext()) {
            State st = (State)it.next();
            Iterator it2 = this.delta(st).iterator();
            while (it2.hasNext()) {
                Transition tr = (Transition)it2.next();
                if (tr.label() == null || !tr.label().equals(o)) continue;
                ns.add(tr.end());
            }
        }
        return ns;
    }

    public void updateTransitionWith(Transition tr, Object msg) {
        Object lbl = tr.label();
        this.alphabet.remove(lbl);
        this.alphabet.add(msg);
        Key k = new Key(tr.start(), lbl);
        Set s = (Set)this.transitions.remove(k);
        if (s != null) {
            this.transitions.put(new Key(tr.start(), msg), s);
        }
        if ((s = (Set)this.reverse.remove(k = new Key(tr.end(), lbl))) != null) {
            this.reverse.put(new Key(tr.end(), msg), s);
        }
        tr.setLabel(msg);
    }

    public Set deltaMinusOne(State st) {
        HashSet s = new HashSet();
        Iterator alphit = this.alphabet().iterator();
        while (alphit.hasNext()) {
            s.addAll(this.deltaMinusOne(st, alphit.next()));
        }
        return s;
    }

    public Set enumerate(int ln) {
        HashSet<List> ret = new HashSet<List>();
        class EnumState {
            State st;
            List word;

            public EnumState(State s, List list) {
                this.st = s;
                this.word = new ArrayList(list);
            }
        }
        LinkedList<EnumState> ll = new LinkedList<EnumState>();
        ArrayList cur = new ArrayList();
        Iterator i = this.initials.iterator();
        while (i.hasNext()) {
            State s = (State)i.next();
            if (s.isTerminal()) {
                ret.add(new ArrayList());
            }
            ll.add(new EnumState(s, cur));
        }
        do {
            EnumState st = (EnumState)ll.removeFirst();
            Set trs = this.delta(st.st);
            List word = st.word;
            Iterator k = trs.iterator();
            while (k.hasNext()) {
                Transition tr = (Transition)k.next();
                word.add(tr.label());
                if (word.size() <= ln) {
                    EnumState en = new EnumState(tr.end(), word);
                    ll.add(en);
                    ret.add(en.word);
                }
                word.remove(word.size() - 1);
            }
        } while (!ll.isEmpty());
        return ret;
    }

    private class Key {
        private State s;
        private Object l;

        protected Key(State s, Object l) {
            this.s = s;
            this.l = l;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            try {
                Key t = (Key)o;
                boolean ret = (this.l == null ? t.l == null : this.l.equals(t.l)) && (this.s == null ? t.s == null : this.s.equals(t.s));
                return ret;
            }
            catch (ClassCastException x) {
                return false;
            }
        }

        public int hashCode() {
            int x = this.s == null ? 0 : this.s.hashCode();
            int y = this.l == null ? 0 : this.l.hashCode();
            return y << 16 | x;
        }
    }
}

