/*
 * Decompiled with CFR 0.152.
 */
package rationals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;

public class RandomAutomaton
extends Automaton {
    private static final Random rand = new Random();
    private int nstate;
    private int fstate;
    private Object[] alph;
    private double density;
    private double deviation;

    public RandomAutomaton(int nstate, int fstate, Object[] alph, double density, double deviation, boolean det) {
        this.nstate = nstate;
        this.fstate = fstate;
        this.alph = alph;
        this.density = density;
        this.deviation = deviation;
        if (det) {
            this.makeDFA();
        } else {
            this.makeNFA();
        }
    }

    private void makeNFA() {
        int i;
        State init = this.addState(true, false);
        for (i = 0; i < this.fstate; ++i) {
            this.addState(false, true);
        }
        for (i = this.fstate; i < this.nstate; ++i) {
            this.addState(false, false);
        }
        State[] sts = this.states().toArray(new State[this.nstate + 1]);
        Iterator it = this.states().iterator();
        while (it.hasNext()) {
            State from = (State)it.next();
            int c = this.alph.length * sts.length * sts.length;
            int nt = (int)((double)c * (this.deviation * rand.nextGaussian() + this.density));
            for (int i2 = 0; i2 < nt; ++i2) {
                State to = sts[rand.nextInt(sts.length)];
                Object lbl = this.alph[rand.nextInt(this.alph.length)];
                try {
                    this.addTransition(new Transition(from, lbl, to));
                    continue;
                }
                catch (NoSuchStateException e1) {
                    // empty catch block
                }
            }
        }
    }

    private void makeDFA() {
        State init = this.addState(true, false);
        ArrayList<State> todo = new ArrayList<State>();
        ArrayList<State> done = new ArrayList<State>();
        int fs = this.fstate;
        int ns = this.nstate;
        todo.add(init);
        while (ns > 0) {
            State from = (State)todo.remove(0);
            done.add(from);
            ArrayList<Object> l = new ArrayList<Object>(Arrays.asList(this.alph));
            int c = this.alph.length * this.nstate;
            int nt = (int)(this.deviation * rand.nextGaussian() + this.density);
            for (int i = 0; i < nt && !l.isEmpty(); ++i) {
                State to = null;
                double r = rand.nextDouble() * (double)(this.nstate - 1);
                if ((int)r < done.size()) {
                    to = (State)done.get((int)r);
                } else {
                    r = rand.nextDouble() * (double)ns;
                    to = this.addState(false, r < (double)fs);
                    todo.add(to);
                    --ns;
                    if (r < (double)fs) {
                        --fs;
                    }
                }
                Object lbl = l.remove(rand.nextInt(l.size()));
                try {
                    this.addTransition(new Transition(from, lbl, to));
                    continue;
                }
                catch (NoSuchStateException e1) {
                    // empty catch block
                }
            }
        }
    }
}

