/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import uk.ac.ebi.ontocat.Ontology;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyServiceException;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.bioportal.BioportalOntologyService;
import uk.ac.ebi.ontocat.ols.OlsOntologyService;
import uk.ac.ebi.ontocat.utils.OntologyParser;
import uk.ac.ebi.ontocat.virtual.CompositeServiceNoThreads;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyBatch {
    private List<OntologyParser> parserList = new ArrayList<OntologyParser>();
    private OntologyService fileService;
    private final Pattern BioportalPattern = Pattern.compile("\\d{4}");
    private final Pattern OLSPattern = Pattern.compile("[a-zA-Z_]{2,11}");
    private OntologyService bos = new BioportalOntologyService();
    private OntologyService los = new OlsOntologyService();

    public OntologyBatch(String dirPath) throws OntologyServiceException {
        File dir = new File(dirPath);
        if (dir.exists()) {
            for (int i = 0; i < dir.listFiles().length; ++i) {
                String fileName;
                if (!dir.listFiles()[i].isFile() || !(fileName = dir.listFiles()[i].getAbsolutePath()).endsWith(".owl") && !fileName.endsWith(".obo")) continue;
                OntologyParser op = new OntologyParser(fileName);
                this.parserList.add(op);
            }
        } else {
            System.out.println("Sorry, can't create Ontology Batch service: directory " + dirPath + " doesn't exist.");
        }
        if (this.parserList.size() == 0) {
            System.out.println("Sorry, can't create Ontology Batch service: there are no owl or obo files in directory " + dirPath + ".");
        } else {
            this.createOntologyService();
        }
    }

    public OntologyBatch() throws OntologyServiceException {
        OntologyParser op = new OntologyParser();
        this.parserList.add(op);
        this.createOntologyService();
    }

    private void createOntologyService() throws OntologyServiceException {
        ArrayList<OntologyService> osList = new ArrayList<OntologyService>();
        for (OntologyParser p : this.parserList) {
            osList.add(p.getOntologyService());
        }
        this.fileService = CompositeServiceNoThreads.getService(osList);
    }

    public void addOntology(String pathToOntology) throws OntologyServiceException {
        OntologyParser op = new OntologyParser(pathToOntology);
        this.parserList.add(op);
        this.createOntologyService();
    }

    public void addEFO() throws OntologyServiceException {
        OntologyParser op = new OntologyParser();
        this.parserList.add(op);
        this.createOntologyService();
    }

    public List<String> listLoadedOntologies() {
        ArrayList<String> result = new ArrayList<String>();
        for (OntologyParser op : this.parserList) {
            result.add(op.getOntologyAccession());
        }
        return result;
    }

    public List<String> listOLSOntologies() throws OntologyServiceException {
        ArrayList<String> result = new ArrayList<String>();
        for (Ontology ot : this.los.getOntologies()) {
            result.add(ot.getOntologyAccession());
        }
        return result;
    }

    public List<String> listBioportalOntologies() throws OntologyServiceException {
        ArrayList<String> result = new ArrayList<String>();
        for (Ontology ot : this.bos.getOntologies()) {
            result.add(ot.getOntologyAccession());
        }
        return result;
    }

    public List<String> listLoadedOntologiesSources() {
        ArrayList<String> result = new ArrayList<String>();
        OntologyParser p = this.parserList.get(1);
        System.out.println(p.getOntologySource());
        for (OntologyParser op : this.parserList) {
            result.add("Accession: " + op.getOntologyAccession() + " Source: " + op.getOntologySource());
        }
        return result;
    }

    public OntologyParser getOntologyParser(String ontologyAccession) throws OntologyServiceException {
        if (this.BioportalPattern.matcher(ontologyAccession).matches()) {
            return new OntologyParser(this.bos, ontologyAccession);
        }
        if (this.OLSPattern.matcher(ontologyAccession).matches()) {
            return new OntologyParser(this.los, ontologyAccession);
        }
        for (OntologyParser op : this.parserList) {
            if (!op.getOntologyAccession().equals(ontologyAccession)) continue;
            return op;
        }
        return null;
    }

    public List<OntologyTerm> searchTermInOLS(String text) throws OntologyServiceException {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        for (Ontology o : this.los.getOntologies()) {
            for (OntologyTerm ot : this.los.searchOntology(o.getOntologyAccession(), text, OntologyService.SearchOptions.EXACT, OntologyService.SearchOptions.INCLUDE_PROPERTIES)) {
                result.add(ot);
            }
        }
        return result;
    }

    public List<OntologyTerm> searchTermInBioportal(String text) throws OntologyServiceException {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        for (OntologyTerm ot : this.bos.searchAll(text, OntologyService.SearchOptions.EXACT, OntologyService.SearchOptions.INCLUDE_PROPERTIES)) {
            result.add(ot);
        }
        return result;
    }

    public List<OntologyTerm> searchTermInAll(String text) throws OntologyServiceException {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        for (OntologyTerm ot : this.fileService.searchAll(text, new OntologyService.SearchOptions[0])) {
            result.add(ot);
        }
        for (OntologyTerm ot : this.bos.searchAll(text, OntologyService.SearchOptions.EXACT, OntologyService.SearchOptions.INCLUDE_PROPERTIES)) {
            result.add(ot);
        }
        for (Ontology o : this.los.getOntologies()) {
            for (OntologyTerm ot : this.los.searchOntology(o.getOntologyAccession(), text, OntologyService.SearchOptions.EXACT, OntologyService.SearchOptions.INCLUDE_PROPERTIES)) {
                result.add(ot);
            }
        }
        return result;
    }

    public List<OntologyTerm> searchTerm(String text) throws OntologyServiceException {
        ArrayList<OntologyTerm> result = new ArrayList<OntologyTerm>();
        for (OntologyTerm ot : this.fileService.searchAll(text, new OntologyService.SearchOptions[0])) {
            result.add(ot);
        }
        return result;
    }
}

